/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaDescriptor;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.HaServiceConfigConstants;

public abstract class HaDescriptorFactory
implements HaServiceConfigConstants {
    public static HaDescriptor createDescriptor() {
        return new DefaultHaDescriptor();
    }

    public static HaServiceConfig createServiceConfig(String serviceName, String config) {
        Map<String, String> configMap = HaDescriptorFactory.parseHaConfiguration(config);
        String zookeeperEnsemble = configMap.get("zookeeperEnsemble");
        String zookeeperNamespace = configMap.get("zookeeperNamespace");
        boolean enabled = Boolean.parseBoolean(configMap.getOrDefault("enabled", Boolean.toString(true)));
        int maxFailoverAttempts = Integer.parseInt(configMap.getOrDefault("maxFailoverAttempts", Integer.toString(3)));
        int failoverSleep = Integer.parseInt(configMap.getOrDefault("failoverSleep", Integer.toString(1000)));
        boolean stickySessionsEnabled = Boolean.parseBoolean(configMap.getOrDefault("enableStickySession", Boolean.toString(false)));
        boolean loadBalancingEnabled = Boolean.parseBoolean(configMap.getOrDefault("enableLoadBalancing", Boolean.toString(false)));
        boolean noFallbackEnabled = Boolean.parseBoolean(configMap.getOrDefault("noFallback", Boolean.toString(false)));
        String stickySessionCookieName = configMap.getOrDefault("stickySessionCookieName", "KNOX_BACKEND");
        String disableLoadBalancingForUserAgentsConfig = configMap.getOrDefault("disableLoadBalancingForUserAgents", "ClouderaODBCDriverforApacheHive");
        List<String> disableLoadBalancingForUserAgents = Collections.EMPTY_LIST;
        if (StringUtils.isNotBlank((CharSequence)disableLoadBalancingForUserAgentsConfig)) {
            disableLoadBalancingForUserAgents = Arrays.asList(disableLoadBalancingForUserAgentsConfig.trim().split("\\s*,\\s*"));
        }
        return HaDescriptorFactory.createServiceConfig(serviceName, enabled, maxFailoverAttempts, failoverSleep, zookeeperEnsemble, zookeeperNamespace, stickySessionsEnabled, loadBalancingEnabled, stickySessionCookieName, noFallbackEnabled, disableLoadBalancingForUserAgents);
    }

    @Deprecated
    public static HaServiceConfig createServiceConfig(String serviceName, String enabledValue, String maxFailoverAttemptsValue, String failoverSleepValue, String zookeeperEnsemble, String zookeeperNamespace, String loadBalancingEnabledValue, String stickySessionsEnabledValue, String stickySessionCookieNameValue, String noFallbackEnabledValue) {
        boolean enabled = true;
        int maxFailoverAttempts = 3;
        int failoverSleep = 1000;
        boolean stickySessionsEnabled = false;
        boolean loadBalancingEnabled = false;
        boolean noFallbackEnabled = false;
        String stickySessionCookieName = "KNOX_BACKEND";
        if (enabledValue != null && !enabledValue.trim().isEmpty()) {
            enabled = Boolean.parseBoolean(enabledValue);
        }
        if (maxFailoverAttemptsValue != null && !maxFailoverAttemptsValue.trim().isEmpty()) {
            maxFailoverAttempts = Integer.parseInt(maxFailoverAttemptsValue);
        }
        if (failoverSleepValue != null && !failoverSleepValue.trim().isEmpty()) {
            failoverSleep = Integer.parseInt(failoverSleepValue);
        }
        if (stickySessionsEnabledValue != null && !stickySessionsEnabledValue.trim().isEmpty()) {
            stickySessionsEnabled = Boolean.parseBoolean(stickySessionsEnabledValue);
        }
        if (loadBalancingEnabledValue != null && !loadBalancingEnabledValue.trim().isEmpty()) {
            loadBalancingEnabled = Boolean.parseBoolean(loadBalancingEnabledValue);
        }
        if (stickySessionCookieNameValue != null && !stickySessionCookieNameValue.trim().isEmpty()) {
            stickySessionCookieName = stickySessionCookieNameValue;
        }
        if (noFallbackEnabledValue != null && !noFallbackEnabledValue.trim().isEmpty()) {
            noFallbackEnabled = Boolean.parseBoolean(noFallbackEnabledValue);
        }
        return HaDescriptorFactory.createServiceConfig(serviceName, enabled, maxFailoverAttempts, failoverSleep, zookeeperEnsemble, zookeeperNamespace, stickySessionsEnabled, loadBalancingEnabled, stickySessionCookieName, noFallbackEnabled, Arrays.asList("ClouderaODBCDriverforApacheHive"));
    }

    private static DefaultHaServiceConfig createServiceConfig(String serviceName, boolean enabled, int maxFailoverAttempts, int failoverSleepValue, String zookeeperEnsemble, String zookeeperNamespace, boolean stickySessionsEnabled, boolean loadBalancingEnabled, String stickySessionCookieName, boolean noFallbackEnabled, List<String> disableStickySessionForUserAgents) {
        DefaultHaServiceConfig serviceConfig = new DefaultHaServiceConfig(serviceName);
        serviceConfig.setEnabled(enabled);
        serviceConfig.setMaxFailoverAttempts(maxFailoverAttempts);
        serviceConfig.setFailoverSleep(failoverSleepValue);
        serviceConfig.setZookeeperEnsemble(zookeeperEnsemble);
        serviceConfig.setZookeeperNamespace(zookeeperNamespace);
        serviceConfig.setStickySessionEnabled(stickySessionsEnabled);
        serviceConfig.setLoadBalancingEnabled(loadBalancingEnabled);
        serviceConfig.setStickySessionCookieName(stickySessionCookieName);
        serviceConfig.setNoFallbackEnabled(noFallbackEnabled);
        serviceConfig.setDisableStickySessionForUserAgents(disableStickySessionForUserAgents);
        return serviceConfig;
    }

    private static Map<String, String> parseHaConfiguration(String configuration) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (configuration != null) {
            String[] pairs;
            for (String pair : pairs = configuration.split(";")) {
                String[] tokens = pair.split("=");
                if (tokens.length != 2) continue;
                parameters.put(tokens[0], tokens[1]);
            }
        }
        return parameters;
    }
}

