/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.SpiGatewayResources;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.config.Optional;
import org.apache.knox.gateway.dispatch.AbstractGatewayDispatch;
import org.apache.knox.gateway.dispatch.InputStreamEntity;
import org.apache.knox.gateway.dispatch.PartiallyRepeatableHttpEntity;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.util.MimeTypes;

public class DefaultDispatch
extends AbstractGatewayDispatch {
    protected static final String SET_COOKIE = "SET-COOKIE";
    protected static final String WWW_AUTHENTICATE = "WWW-AUTHENTICATE";
    protected static final Set<String> EXCLUDE_SET_COOKIES_DEFAULT = new HashSet<String>(Arrays.asList("hadoop.auth", "hive.server2.auth", "impala.auth"));
    protected static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    protected static final SpiGatewayResources RES = (SpiGatewayResources)ResourcesFactory.get(SpiGatewayResources.class);
    protected static final Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    protected static final String EXCLUDE_ALL = "*";
    private Set<String> outboundResponseExcludeHeaders = Collections.singleton("WWW-AUTHENTICATE");
    private Set<String> outboundResponseExcludedSetCookieHeaderDirectives = Collections.singleton("*");
    @Optional
    @Configure
    private String serviceRole;
    private int replayBufferSize = -1;

    @Override
    public void destroy() {
    }

    protected int getReplayBufferSize() {
        if (this.replayBufferSize > 0) {
            return Math.abs(this.replayBufferSize / 1024);
        }
        return this.replayBufferSize;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    @Configure
    protected void setReplayBufferSize(@Default(value="-1") int size) {
        this.setReplayBufferSizeInBytes(size);
    }

    protected int getReplayBufferSizeInBytes() {
        return this.replayBufferSize;
    }

    protected void setReplayBufferSizeInBytes(int size) {
        if (size > 0) {
            size *= 1024;
        }
        this.replayBufferSize = size;
        LOG.setReplayBufferSize(this.replayBufferSize, this.getServiceRole());
    }

    protected void executeRequestWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
    }

    protected void outboundResponseWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = this.executeOutboundRequest(outboundRequest);
        this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    protected HttpResponse executeOutboundRequest(HttpUriRequest outboundRequest) throws IOException {
        HttpResponse inboundResponse;
        LOG.dispatchRequest(outboundRequest.getMethod(), outboundRequest.getURI());
        try {
            int statusCode;
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "unavailable", RES.requestMethod(outboundRequest.getMethod()));
            if (!Boolean.parseBoolean(System.getProperty("gateway.hadoop.kerberos.secured"))) {
                this.addCredentialsToRequest(outboundRequest);
            }
            if ((statusCode = (inboundResponse = this.getHttpClient().execute(outboundRequest)).getStatusLine().getStatusCode()) != 201) {
                LOG.dispatchResponseStatusCode(statusCode);
            } else {
                Header location = inboundResponse.getFirstHeader("Location");
                if (location == null) {
                    LOG.dispatchResponseStatusCode(statusCode);
                } else {
                    LOG.dispatchResponseCreatedStatusCode(statusCode, location.getValue());
                }
            }
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "success", RES.responseStatus(statusCode));
        }
        catch (Exception e) {
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "failure");
            LOG.dispatchServiceConnectionException(outboundRequest.getURI(), e);
            throw new IOException(RES.dispatchConnectionError());
        }
        return inboundResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        this.outboundResponseWrapper(outboundRequest, inboundRequest, outboundResponse);
        outboundResponse.setStatus(inboundResponse.getStatusLine().getStatusCode());
        this.copyResponseHeaderFields(outboundResponse, inboundResponse);
        HttpEntity entity = inboundResponse.getEntity();
        if (entity != null) {
            outboundResponse.setContentType(this.getInboundResponseContentType(entity));
            InputStream stream = entity.getContent();
            try {
                this.writeResponse(inboundRequest, outboundResponse, stream);
            }
            finally {
                this.closeInboundResponse(inboundResponse, stream);
            }
        }
    }

    protected String getInboundResponseContentType(HttpEntity entity) {
        ContentType entityContentType;
        String fullContentType = null;
        if (entity != null && (entityContentType = ContentType.get((HttpEntity)entity)) != null) {
            if (entityContentType.getCharset() == null) {
                String entityMimeType = entityContentType.getMimeType();
                String defaultCharset = MimeTypes.getDefaultCharsetForMimeType((String)entityMimeType);
                if (defaultCharset != null) {
                    LOG.usingDefaultCharsetForEntity(entityMimeType, defaultCharset);
                    entityContentType = entityContentType.withCharset(defaultCharset);
                }
            } else {
                LOG.usingExplicitCharsetForEntity(entityContentType.getMimeType(), entityContentType.getCharset());
            }
            fullContentType = entityContentType.toString();
        }
        if (fullContentType == null) {
            LOG.unknownResponseEntityContentType();
        } else {
            LOG.inboundResponseEntityContentType(fullContentType);
        }
        return fullContentType;
    }

    protected void closeInboundResponse(HttpResponse response, InputStream stream) throws IOException {
        try {
            stream.close();
        }
        finally {
            if (response instanceof Closeable) {
                ((Closeable)response).close();
            }
        }
    }

    protected void addCredentialsToRequest(HttpUriRequest outboundRequest) {
    }

    protected HttpEntity createRequestEntity(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        ServletInputStream contentStream = request.getInputStream();
        Object entity = contentType == null ? new InputStreamEntity((InputStream)contentStream, contentLength) : new InputStreamEntity((InputStream)contentStream, contentLength, ContentType.parse((String)contentType));
        GatewayConfig config = (GatewayConfig)request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (config != null && config.isHadoopKerberosSecured()) {
            boolean delegationTokenPresent = false;
            String queryString = request.getQueryString();
            if (queryString != null) {
                boolean bl = delegationTokenPresent = queryString.startsWith("delegation=") || queryString.contains("&delegation=");
            }
            if (this.replayBufferSize < 0) {
                this.replayBufferSize = config.getHttpServerRequestBuffer();
            }
            if (!delegationTokenPresent && this.replayBufferSize > 0) {
                entity = new PartiallyRepeatableHttpEntity((HttpEntity)entity, this.replayBufferSize);
            }
        }
        return entity;
    }

    @Override
    public void doGet(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpGet method = new HttpGet(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doOptions(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpOptions method = new HttpOptions(url);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doPut(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpPut method = new HttpPut(url);
        HttpEntity entity = this.createRequestEntity(request);
        method.setEntity(entity);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doPatch(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpPatch method = new HttpPatch(url);
        HttpEntity entity = this.createRequestEntity(request);
        method.setEntity(entity);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doPost(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpPost method = new HttpPost(url);
        HttpEntity entity = this.createRequestEntity(request);
        method.setEntity(entity);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doDelete(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpDelete method = new HttpDelete(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    @Override
    public void doHead(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpHead method = new HttpHead(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequestWrapper((HttpUriRequest)method, request, response);
    }

    public void copyResponseHeaderFields(HttpServletResponse outboundResponse, HttpResponse inboundResponse) {
        TreeMap<String, Set<String>> excludedHeaderDirectives = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        this.getOutboundResponseExcludeHeaders().stream().forEach(excludeHeader -> excludedHeaderDirectives.put((String)excludeHeader, Collections.singleton(EXCLUDE_ALL)));
        excludedHeaderDirectives.put(SET_COOKIE, this.getOutboundResponseExcludedSetCookieHeaderDirectives());
        for (Header header : inboundResponse.getAllHeaders()) {
            boolean isBlockedAuthHeader = Arrays.stream(header.getElements()).anyMatch(h -> EXCLUDE_SET_COOKIES_DEFAULT.contains(h.getName()) && this.getOutboundResponseExcludedSetCookieHeaderDirectives().contains(h.getName()));
            if (!isBlockedAuthHeader) {
                String responseHeaderValue = this.calculateResponseHeaderValue(header, excludedHeaderDirectives);
                if (responseHeaderValue.isEmpty()) continue;
                outboundResponse.addHeader(header.getName(), responseHeaderValue);
                LOG.addedOutboundheader(header.getName(), responseHeaderValue);
                continue;
            }
            LOG.skippedOutboundHeader(header.getName(), header.getValue());
        }
    }

    private String calculateResponseHeaderValue(Header headerToCheck, Map<String, Set<String>> excludedHeaderDirectives) {
        Set<String> excludedHeaderValues;
        String headerNameToCheck = headerToCheck.getName();
        if (excludedHeaderDirectives != null && excludedHeaderDirectives.containsKey(headerNameToCheck) && !(excludedHeaderValues = excludedHeaderDirectives.get(headerNameToCheck)).isEmpty()) {
            LinkedHashSet headerValuesToCheck;
            String separator;
            if (excludedHeaderValues.stream().anyMatch(e -> e.equals(EXCLUDE_ALL))) {
                return "";
            }
            String string = separator = SET_COOKIE.equalsIgnoreCase(headerNameToCheck) ? "; " : " ";
            if (headerToCheck.getName().equalsIgnoreCase(SET_COOKIE)) {
                headerValuesToCheck = new LinkedHashSet(Arrays.asList(headerToCheck.getValue().trim().split(";")));
                headerValuesToCheck = headerValuesToCheck.stream().map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));
            } else {
                headerValuesToCheck = new LinkedHashSet<String>(Arrays.asList(headerToCheck.getValue().trim().split("\\s+")));
            }
            headerValuesToCheck = headerValuesToCheck.stream().map(h -> h.replaceAll(separator.trim(), "")).collect(Collectors.toCollection(LinkedHashSet::new));
            headerValuesToCheck.removeIf(h -> excludedHeaderValues.stream().anyMatch(e -> h.contains((CharSequence)e)));
            return headerValuesToCheck.isEmpty() ? "" : String.join((CharSequence)separator, headerValuesToCheck);
        }
        return headerToCheck.getValue();
    }

    public Set<String> getOutboundResponseExcludeHeaders() {
        return this.outboundResponseExcludeHeaders == null ? Collections.emptySet() : this.outboundResponseExcludeHeaders;
    }

    public Set<String> getOutboundResponseExcludedSetCookieHeaderDirectives() {
        return this.outboundResponseExcludedSetCookieHeaderDirectives == null ? Collections.emptySet() : this.outboundResponseExcludedSetCookieHeaderDirectives;
    }
}

