/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;

public class UrlRewriteContextImpl
implements UrlRewriteContext {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private UrlRewriteEnvironment environment;
    private Resolver resolver;
    private Evaluator evaluator;
    private Map<String, UrlRewriteFunctionProcessor> functions;
    private ContextParameters params;
    private UrlRewriter.Direction direction;
    private Template originalUrl;
    private Template currentUrl;

    public UrlRewriteContextImpl(UrlRewriteEnvironment environment, Resolver resolver, Map<String, UrlRewriteFunctionProcessor> functions, UrlRewriter.Direction direction, Template url) {
        this.environment = environment;
        this.resolver = resolver;
        this.functions = functions;
        this.params = new ContextParameters();
        this.evaluator = new ContextEvaluator();
        this.direction = direction;
        this.originalUrl = url;
        this.currentUrl = url;
    }

    @Override
    public UrlRewriter.Direction getDirection() {
        return this.direction;
    }

    @Override
    public Template getOriginalUrl() {
        return this.originalUrl;
    }

    @Override
    public Template getCurrentUrl() {
        return this.currentUrl;
    }

    @Override
    public void setCurrentUrl(Template url) {
        this.currentUrl = url;
    }

    @Override
    public void addParameters(Params parameters) {
        this.params.add(parameters);
    }

    @Override
    public Params getParameters() {
        return this.params;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    private class ContextEvaluator
    implements Evaluator {
        private ContextEvaluator() {
        }

        public List<String> evaluate(String function, List<String> parameters) {
            List<String> results = null;
            UrlRewriteFunctionProcessor processor = (UrlRewriteFunctionProcessor)UrlRewriteContextImpl.this.functions.get(function);
            if (processor != null) {
                try {
                    results = processor.resolve(UrlRewriteContextImpl.this, parameters);
                }
                catch (Exception e) {
                    LOG.failedToInvokeRewriteFunction(function, e);
                    results = null;
                }
            }
            return results;
        }
    }

    private class ContextParameters
    implements Params {
        Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();

        private ContextParameters() {
        }

        public Set<String> getNames() {
            return this.map.keySet();
        }

        public List<String> resolve(String name) {
            List values = this.map.get(name);
            if (values == null) {
                try {
                    values = UrlRewriteContextImpl.this.resolver.resolve(name);
                    if (values == null) {
                        values = UrlRewriteContextImpl.this.environment.resolve(name);
                    }
                }
                catch (Exception e) {
                    LOG.failedToFindValuesByParameter(name, e);
                }
            }
            return values;
        }

        public void add(Params params) {
            for (String name : params.getNames()) {
                this.map.put(name, params.resolve(name));
            }
        }
    }
}

