/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import com.github.scribejava.core.oauth2.clientauthentication.HttpBasicAuthenticationScheme;
import com.github.scribejava.core.oauth2.clientauthentication.RequestBodyAuthenticationScheme;
import org.pac4j.core.exception.TechnicalException;

public class GenericApi20
extends DefaultApi20 {
    public static final String BASIC_AUTH_AUTHENTICATION_METHOD = "basicAuth";
    public static final String REQUEST_BODY_AUTHENTICATION_METHOD = "requestBody";
    protected final String authUrl;
    protected final String tokenUrl;
    protected Verb accessTokenVerb = Verb.POST;
    protected String clientAuthenticationMethod = "basicAuth";

    public GenericApi20(String authUrl, String tokenUrl) {
        this.authUrl = authUrl;
        this.tokenUrl = tokenUrl;
    }

    public Verb getAccessTokenVerb() {
        return this.accessTokenVerb;
    }

    public void setAccessTokenVerb(Verb verb) {
        this.accessTokenVerb = verb;
    }

    public String getAccessTokenEndpoint() {
        return this.tokenUrl;
    }

    protected String getAuthorizationBaseUrl() {
        return this.authUrl;
    }

    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public ClientAuthentication getClientAuthentication() {
        if (BASIC_AUTH_AUTHENTICATION_METHOD.equalsIgnoreCase(this.clientAuthenticationMethod)) {
            return HttpBasicAuthenticationScheme.instance();
        }
        if (REQUEST_BODY_AUTHENTICATION_METHOD.equalsIgnoreCase(this.clientAuthenticationMethod)) {
            return RequestBodyAuthenticationScheme.instance();
        }
        throw new TechnicalException("Unsupported client authentication method: " + this.clientAuthenticationMethod);
    }
}

