/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class CollectionUtils {
    public static <T> boolean isSorted(Collection<T> collection, Comparator<T> comparator) {
        if (collection != null) {
            if (collection.isEmpty() || collection.size() == 1) {
                return true;
            }
            Iterator<T> iterator = collection.iterator();
            T previous = iterator.next();
            while (iterator.hasNext()) {
                T current = iterator.next();
                if (comparator.compare(previous, current) > 0) {
                    return false;
                }
                previous = current;
            }
            return true;
        }
        return false;
    }
}

