/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.io.IOException;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.shell")
public interface KnoxShellMessages {
    @Message(level=MessageLevel.WARN, text="Unable to create provided PEM encoded trusted cert - falling through for other truststores: {0}")
    public void unableToLoadProvidedPEMEncodedTrustedCert(@StackTrace(level=MessageLevel.DEBUG) IOException var1);

    @Message(level=MessageLevel.DEBUG, text="No available Subject; Using JAAS configuration login")
    public void noSubjectAvailable();

    @Message(level=MessageLevel.DEBUG, text="Using JAAS configuration file implementation: {0}")
    public void usingJAASConfigurationFileImplementation(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to create JAAS configuration file implementation {0}: {1}")
    public void failedToLoadJAASConfigurationFileImplementation(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to instantiate JAAS configuration file implementation {0}: {1}")
    public void failedToInstantiateJAASConfigurationFileImplementation(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="No JAAS configuration file implementation is available")
    public void noJAASConfigurationFileImplementation();

    @Message(level=MessageLevel.ERROR, text="Failed to create the JAAS configuration: {0}")
    public void failedToLoadJAASConfiguration(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to locate the specified JAAS configuration: {0}")
    public void failedToLocateJAASConfiguration(String var1);

    @Message(level=MessageLevel.ERROR, text="The specified JAAS configuration does not exist: {0}")
    public void jaasConfigurationDoesNotExist(String var1);

    @Message(level=MessageLevel.INFO, text="Using default JAAS configuration")
    public void usingDefaultJAASConfiguration();

    @Message(level=MessageLevel.DEBUG, text="JAAS configuration: {0}")
    public void jaasConfigurationLocation(String var1);

    @Message(level=MessageLevel.WARN, text="The javax.security.auth.useSubjectCredsOnly system property is set to 'false'; This may yield unexpected results with respect to Kerberos authentication.")
    public void useSubjectCredsOnlyIsFalse();
}

