/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.manager.ListResourcesRequest;
import org.apache.knox.gateway.shell.manager.ResourceType;

class DeployResourceRequest
extends AbstractRequest<BasicResponse> {
    private ResourceType resourceType;
    private String resourceName;
    private String resourceFileName;

    DeployResourceRequest(KnoxSession session, ResourceType type, String name, String resourceFileName) {
        super(session);
        this.resourceType = type;
        this.resourceName = name;
        this.resourceFileName = resourceFileName;
    }

    public void execute() throws Exception {
        if (this.isExistingResource()) {
            throw new IllegalStateException("A " + this.resourceType.getName() + " resource with the same name (" + this.resourceName + ") is already deployed.");
        }
        this.callable().call();
    }

    @Override
    protected Callable<BasicResponse> callable() {
        return () -> {
            URIBuilder uri = this.uri("/admin/api/v1/", this.resourceType.getName(), "/", this.resourceName);
            HttpPut request = new HttpPut(uri.build());
            if (this.resourceFileName != null) {
                File resource = new File(this.resourceFileName);
                if (!resource.exists()) {
                    throw new FileNotFoundException(this.resourceFileName);
                }
                FileEntity entity = new FileEntity(new File(this.resourceFileName), ContentType.APPLICATION_JSON);
                request.setEntity((HttpEntity)entity);
            }
            return new BasicResponse((HttpResponse)this.execute((HttpRequest)request));
        };
    }

    private boolean isExistingResource() throws Exception {
        boolean result = false;
        List<String> existing = new ListResourcesRequest(this.hadoop(), this.resourceType).execute();
        if (existing != null) {
            result = existing.contains(this.resourceName);
        }
        return result;
    }
}

