/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;
import org.apache.knox.gateway.shell.table.KnoxShellTableRowDeserializer;

public class JSONKnoxShellTableBuilder
extends KnoxShellTableBuilder {
    JSONKnoxShellTableBuilder(KnoxShellTable table) {
        super(table);
    }

    public KnoxShellTable fromJson(String json) throws IOException {
        return this.toKnoxShellTable(json);
    }

    private KnoxShellTable toKnoxShellTable(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        SimpleModule module = new SimpleModule();
        module.addDeserializer(KnoxShellTable.class, (JsonDeserializer)new KnoxShellTableRowDeserializer(this.table));
        mapper.registerModule((Module)module);
        KnoxShellTable tableFromJson = (KnoxShellTable)mapper.readValue(json, (TypeReference)new TypeReference<KnoxShellTable>(){});
        if (this.title != null) {
            tableFromJson.title(this.title);
        }
        return tableFromJson;
    }

    public KnoxShellTable path(String path) throws IOException {
        return this.toKnoxShellTable(FileUtils.readFileToString((File)new File(path), (Charset)StandardCharsets.UTF_8));
    }
}

