/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class StickySessionCookieRemovedRequest
extends HttpServletRequestWrapper {
    private final Cookie[] cookies;

    StickySessionCookieRemovedRequest(String cookieName, HttpServletRequest request) {
        super(request);
        this.cookies = this.filterCookies(cookieName, request.getCookies());
    }

    private Cookie[] filterCookies(String cookieName, Cookie[] cookies) {
        if (super.getCookies() == null) {
            return null;
        }
        ArrayList<Cookie> cookiesInternal = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (cookieName.equals(cookie.getName())) continue;
            cookiesInternal.add(cookie);
        }
        return cookiesInternal.toArray(new Cookie[0]);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }
}

