/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.transport;

import java.net.InetSocketAddress;
import org.apache.directory.server.protocol.shared.transport.AbstractTransport;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.transport.socket.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
extends AbstractTransport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransport.class);

    public UdpTransport() {
    }

    public UdpTransport(int udpPort) {
        super(udpPort);
        this.acceptor = this.createAcceptor(null, udpPort);
        LOG.debug("UDP Transport created : <*:{},>", (Object)udpPort);
    }

    public UdpTransport(String address, int udpPort) {
        super(address, udpPort);
        this.acceptor = this.createAcceptor(address, udpPort);
        LOG.debug("UDP Transport created : <{}:{},>", (Object)address, (Object)udpPort);
    }

    @Override
    public void init() {
        this.acceptor = this.createAcceptor(this.getAddress(), this.getPort());
        LOG.debug("UDP Transport created : <{}:{},>", (Object)this.getAddress(), (Object)this.getPort());
    }

    public DatagramAcceptor getAcceptor() {
        if (this.acceptor != null && this.acceptor.isDisposed()) {
            this.acceptor = this.createAcceptor(this.getAddress(), this.getPort());
        }
        return this.acceptor == null ? null : (DatagramAcceptor)this.acceptor;
    }

    private IoAcceptor createAcceptor(String address, int port) {
        NioDatagramAcceptor acceptor = new NioDatagramAcceptor();
        InetSocketAddress socketAddress = null;
        socketAddress = address == null ? new InetSocketAddress(port) : new InetSocketAddress(address, port);
        acceptor.setDefaultLocalAddress(socketAddress);
        return acceptor;
    }

    @Override
    public String toString() {
        return "UdpTransport" + super.toString();
    }
}

