/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class TruststoreSSLContextUtils {
    private static final GatewaySpiMessages LOGGER = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);

    private TruststoreSSLContextUtils() {
    }

    public static SSLContext getTruststoreSSLContext(KeyStore truststore) {
        SSLContext sslContext = null;
        try {
            if (truststore != null) {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                sslContextBuilder.loadTrustMaterial(truststore, null);
                sslContext = sslContextBuilder.build();
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.failedToLoadTruststore(e.getMessage(), e);
        }
        return sslContext;
    }

    public static X509TrustManager getTrustManager(KeyStore truststore) {
        try {
            if (truststore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(truststore);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers != null) {
                    for (Object tm : trustManagers) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        return (X509TrustManager)tm;
                    }
                }
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
        }
        catch (IllegalStateException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.failedToLoadTruststore(e.getMessage(), e);
        }
        return null;
    }
}

