/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.factory.ProfileFactory;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProfileDefinition<P extends CommonProfile> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String profileId = null;
    private final List<String> primaries = new ArrayList<String>();
    private final List<String> secondaries = new ArrayList<String>();
    private final Map<String, AttributeConverter<? extends Object>> converters = new HashMap<String, AttributeConverter<? extends Object>>();
    protected ProfileFactory<P> newProfile = parameters -> new CommonProfile();

    public P newProfile(Object ... parameters) {
        return (P)((CommonProfile)this.newProfile.apply(parameters));
    }

    public void convertAndAdd(CommonProfile profile, AttributeLocation attributeLocation, String name, Object value) {
        if (value != null) {
            Object convertedValue;
            AttributeConverter<? extends Object> converter = this.converters.get(name);
            if (converter != null) {
                convertedValue = converter.convert(value);
                if (convertedValue != null) {
                    this.logger.debug("converted to => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
                }
            } else {
                convertedValue = value;
                this.logger.debug("no conversion => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
            }
            if (attributeLocation.equals((Object)AttributeLocation.AUTHENTICATION_ATTRIBUTE)) {
                profile.addAuthenticationAttribute(name, convertedValue);
            } else {
                profile.addAttribute(name, convertedValue);
            }
        }
    }

    public void convertAndAdd(CommonProfile profile, Map<String, Object> profileAttributes, Map<String, Object> authenticationAttributes) {
        if (profileAttributes != null) {
            profileAttributes.entrySet().stream().forEach(entry -> this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, (String)entry.getKey(), entry.getValue()));
        }
        if (authenticationAttributes != null) {
            authenticationAttributes.entrySet().stream().forEach(entry -> this.convertAndAdd(profile, AttributeLocation.AUTHENTICATION_ATTRIBUTE, (String)entry.getKey(), entry.getValue()));
        }
    }

    protected void setProfileFactory(ProfileFactory<P> profileFactory) {
        CommonHelper.assertNotNull("profileFactory", profileFactory);
        this.newProfile = profileFactory;
    }

    protected void primary(String name, AttributeConverter<? extends Object> converter) {
        this.primaries.add(name);
        this.converters.put(name, converter);
    }

    protected void secondary(String name, AttributeConverter<? extends Object> converter) {
        this.secondaries.add(name);
        this.converters.put(name, converter);
    }

    public List<String> getPrimaryAttributes() {
        return this.primaries;
    }

    public List<String> getSecondaryAttributes() {
        return this.secondaries;
    }

    protected Map<String, AttributeConverter<? extends Object>> getConverters() {
        return this.converters;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }
}

