/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceRegistryService;
import org.apache.knox.gateway.services.security.CryptoService;

public class ServiceRegistryServiceFactory
extends AbstractServiceFactory {
    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        DefaultServiceRegistryService service = null;
        if (this.shouldCreateService(implementation)) {
            service = new DefaultServiceRegistryService();
            service.setCryptoService((CryptoService)gatewayServices.getService(ServiceType.CRYPTO_SERVICE));
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.SERVICE_REGISTRY_SERVICE;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.singleton(DefaultServiceRegistryService.class.getName());
    }
}

