/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.monitor;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.knox.gateway.services.topology.monitor.DescriptorsMonitor;
import org.apache.knox.gateway.topology.simple.ProviderConfigurationParser;

public class SharedProviderConfigMonitor
extends FileAlterationListenerAdaptor
implements FileFilter {
    public static final List<String> SUPPORTED_EXTENSIONS = ProviderConfigurationParser.SUPPORTED_EXTENSIONS;
    private DescriptorsMonitor descriptorsMonitor;
    private File descriptorsDir;

    public SharedProviderConfigMonitor(DescriptorsMonitor descMonitor, File descriptorsDir) {
        this.descriptorsMonitor = descMonitor;
        this.descriptorsDir = descriptorsDir;
    }

    public void onFileCreate(File file) {
        this.onFileChange(file);
    }

    public void onFileDelete(File file) {
        this.onFileChange(file);
    }

    public void onFileChange(File file) {
        for (File descriptor : this.getReferencingDescriptors(file)) {
            descriptor.setLastModified(System.currentTimeMillis());
        }
    }

    private List<File> getReferencingDescriptors(File sharedProviderConfig) {
        ArrayList<File> references = new ArrayList<File>();
        for (File descriptor : FileUtils.listFiles((File)this.descriptorsDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            if (!DescriptorsMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)descriptor.getName()))) continue;
            for (String reference : this.descriptorsMonitor.getReferencingDescriptors(FilenameUtils.normalize((String)sharedProviderConfig.getAbsolutePath()))) {
                references.add(new File(reference));
            }
        }
        return references;
    }

    @Override
    public boolean accept(File file) {
        String extension;
        boolean accept = false;
        if (!file.isDirectory() && file.canRead() && SUPPORTED_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
            accept = true;
        }
        return accept;
    }
}

