/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiImpalaTenantUtilizationList;
import com.cloudera.api.swagger.model.ApiImpalaUtilizationHistogram;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Utilization report information of a Impala application service.")
public class ApiImpalaUtilization {
    @SerializedName(value="totalQueries")
    private BigDecimal totalQueries = null;
    @SerializedName(value="successfulQueries")
    private BigDecimal successfulQueries = null;
    @SerializedName(value="oomQueries")
    private BigDecimal oomQueries = null;
    @SerializedName(value="timeOutQueries")
    private BigDecimal timeOutQueries = null;
    @SerializedName(value="rejectedQueries")
    private BigDecimal rejectedQueries = null;
    @SerializedName(value="successfulQueriesPercentage")
    private BigDecimal successfulQueriesPercentage = null;
    @SerializedName(value="oomQueriesPercentage")
    private BigDecimal oomQueriesPercentage = null;
    @SerializedName(value="timeOutQueriesPercentage")
    private BigDecimal timeOutQueriesPercentage = null;
    @SerializedName(value="rejectedQueriesPercentage")
    private BigDecimal rejectedQueriesPercentage = null;
    @SerializedName(value="avgWaitTimeInQueue")
    private BigDecimal avgWaitTimeInQueue = null;
    @SerializedName(value="peakAllocationTimestampMS")
    private BigDecimal peakAllocationTimestampMS = null;
    @SerializedName(value="maxAllocatedMemory")
    private BigDecimal maxAllocatedMemory = null;
    @SerializedName(value="maxAllocatedMemoryPercentage")
    private BigDecimal maxAllocatedMemoryPercentage = null;
    @SerializedName(value="utilizedAtMaxAllocated")
    private BigDecimal utilizedAtMaxAllocated = null;
    @SerializedName(value="utilizedAtMaxAllocatedPercentage")
    private BigDecimal utilizedAtMaxAllocatedPercentage = null;
    @SerializedName(value="peakUsageTimestampMS")
    private BigDecimal peakUsageTimestampMS = null;
    @SerializedName(value="maxUtilizedMemory")
    private BigDecimal maxUtilizedMemory = null;
    @SerializedName(value="maxUtilizedMemoryPercentage")
    private BigDecimal maxUtilizedMemoryPercentage = null;
    @SerializedName(value="allocatedAtMaxUtilized")
    private BigDecimal allocatedAtMaxUtilized = null;
    @SerializedName(value="allocatedAtMaxUtilizedPercentage")
    private BigDecimal allocatedAtMaxUtilizedPercentage = null;
    @SerializedName(value="distributionUtilizedByImpalaDaemon")
    private ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon = null;
    @SerializedName(value="distributionAllocatedByImpalaDaemon")
    private ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon = null;
    @SerializedName(value="tenantUtilizations")
    private ApiImpalaTenantUtilizationList tenantUtilizations = null;
    @SerializedName(value="errorMessage")
    private String errorMessage = null;

    public ApiImpalaUtilization totalQueries(BigDecimal totalQueries) {
        this.totalQueries = totalQueries;
        return this;
    }

    @Schema(description="Total number of queries submitted to Impala.")
    public BigDecimal getTotalQueries() {
        return this.totalQueries;
    }

    public void setTotalQueries(BigDecimal totalQueries) {
        this.totalQueries = totalQueries;
    }

    public ApiImpalaUtilization successfulQueries(BigDecimal successfulQueries) {
        this.successfulQueries = successfulQueries;
        return this;
    }

    @Schema(description="Number of queries that finished successfully.")
    public BigDecimal getSuccessfulQueries() {
        return this.successfulQueries;
    }

    public void setSuccessfulQueries(BigDecimal successfulQueries) {
        this.successfulQueries = successfulQueries;
    }

    public ApiImpalaUtilization oomQueries(BigDecimal oomQueries) {
        this.oomQueries = oomQueries;
        return this;
    }

    @Schema(description="Number of queries that failed due to insufficient memory.")
    public BigDecimal getOomQueries() {
        return this.oomQueries;
    }

    public void setOomQueries(BigDecimal oomQueries) {
        this.oomQueries = oomQueries;
    }

    public ApiImpalaUtilization timeOutQueries(BigDecimal timeOutQueries) {
        this.timeOutQueries = timeOutQueries;
        return this;
    }

    @Schema(description="Number of queries that timed out while waiting for resources in a pool.")
    public BigDecimal getTimeOutQueries() {
        return this.timeOutQueries;
    }

    public void setTimeOutQueries(BigDecimal timeOutQueries) {
        this.timeOutQueries = timeOutQueries;
    }

    public ApiImpalaUtilization rejectedQueries(BigDecimal rejectedQueries) {
        this.rejectedQueries = rejectedQueries;
        return this;
    }

    @Schema(description="Number of queries that were rejected by Impala because the pool was full.")
    public BigDecimal getRejectedQueries() {
        return this.rejectedQueries;
    }

    public void setRejectedQueries(BigDecimal rejectedQueries) {
        this.rejectedQueries = rejectedQueries;
    }

    public ApiImpalaUtilization successfulQueriesPercentage(BigDecimal successfulQueriesPercentage) {
        this.successfulQueriesPercentage = successfulQueriesPercentage;
        return this;
    }

    @Schema(description="Percentage of queries that finished successfully.")
    public BigDecimal getSuccessfulQueriesPercentage() {
        return this.successfulQueriesPercentage;
    }

    public void setSuccessfulQueriesPercentage(BigDecimal successfulQueriesPercentage) {
        this.successfulQueriesPercentage = successfulQueriesPercentage;
    }

    public ApiImpalaUtilization oomQueriesPercentage(BigDecimal oomQueriesPercentage) {
        this.oomQueriesPercentage = oomQueriesPercentage;
        return this;
    }

    @Schema(description="Percentage of queries that failed due to insufficient memory.")
    public BigDecimal getOomQueriesPercentage() {
        return this.oomQueriesPercentage;
    }

    public void setOomQueriesPercentage(BigDecimal oomQueriesPercentage) {
        this.oomQueriesPercentage = oomQueriesPercentage;
    }

    public ApiImpalaUtilization timeOutQueriesPercentage(BigDecimal timeOutQueriesPercentage) {
        this.timeOutQueriesPercentage = timeOutQueriesPercentage;
        return this;
    }

    @Schema(description="Percentage of queries that timed out while waiting for resources in a pool.")
    public BigDecimal getTimeOutQueriesPercentage() {
        return this.timeOutQueriesPercentage;
    }

    public void setTimeOutQueriesPercentage(BigDecimal timeOutQueriesPercentage) {
        this.timeOutQueriesPercentage = timeOutQueriesPercentage;
    }

    public ApiImpalaUtilization rejectedQueriesPercentage(BigDecimal rejectedQueriesPercentage) {
        this.rejectedQueriesPercentage = rejectedQueriesPercentage;
        return this;
    }

    @Schema(description="Percentage of queries that were rejected by Impala because the pool was full.")
    public BigDecimal getRejectedQueriesPercentage() {
        return this.rejectedQueriesPercentage;
    }

    public void setRejectedQueriesPercentage(BigDecimal rejectedQueriesPercentage) {
        this.rejectedQueriesPercentage = rejectedQueriesPercentage;
    }

    public ApiImpalaUtilization avgWaitTimeInQueue(BigDecimal avgWaitTimeInQueue) {
        this.avgWaitTimeInQueue = avgWaitTimeInQueue;
        return this;
    }

    @Schema(description="Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.")
    public BigDecimal getAvgWaitTimeInQueue() {
        return this.avgWaitTimeInQueue;
    }

    public void setAvgWaitTimeInQueue(BigDecimal avgWaitTimeInQueue) {
        this.avgWaitTimeInQueue = avgWaitTimeInQueue;
    }

    public ApiImpalaUtilization peakAllocationTimestampMS(BigDecimal peakAllocationTimestampMS) {
        this.peakAllocationTimestampMS = peakAllocationTimestampMS;
        return this;
    }

    @Schema(description="The time when Impala reserved the maximum amount of memory for queries.")
    public BigDecimal getPeakAllocationTimestampMS() {
        return this.peakAllocationTimestampMS;
    }

    public void setPeakAllocationTimestampMS(BigDecimal peakAllocationTimestampMS) {
        this.peakAllocationTimestampMS = peakAllocationTimestampMS;
    }

    public ApiImpalaUtilization maxAllocatedMemory(BigDecimal maxAllocatedMemory) {
        this.maxAllocatedMemory = maxAllocatedMemory;
        return this;
    }

    @Schema(description="The maximum memory (in bytes) that was reserved by Impala for executing queries.")
    public BigDecimal getMaxAllocatedMemory() {
        return this.maxAllocatedMemory;
    }

    public void setMaxAllocatedMemory(BigDecimal maxAllocatedMemory) {
        this.maxAllocatedMemory = maxAllocatedMemory;
    }

    public ApiImpalaUtilization maxAllocatedMemoryPercentage(BigDecimal maxAllocatedMemoryPercentage) {
        this.maxAllocatedMemoryPercentage = maxAllocatedMemoryPercentage;
        return this;
    }

    @Schema(description="The maximum percentage of memory that was reserved by Impala for executing queries.")
    public BigDecimal getMaxAllocatedMemoryPercentage() {
        return this.maxAllocatedMemoryPercentage;
    }

    public void setMaxAllocatedMemoryPercentage(BigDecimal maxAllocatedMemoryPercentage) {
        this.maxAllocatedMemoryPercentage = maxAllocatedMemoryPercentage;
    }

    public ApiImpalaUtilization utilizedAtMaxAllocated(BigDecimal utilizedAtMaxAllocated) {
        this.utilizedAtMaxAllocated = utilizedAtMaxAllocated;
        return this;
    }

    @Schema(description="The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.")
    public BigDecimal getUtilizedAtMaxAllocated() {
        return this.utilizedAtMaxAllocated;
    }

    public void setUtilizedAtMaxAllocated(BigDecimal utilizedAtMaxAllocated) {
        this.utilizedAtMaxAllocated = utilizedAtMaxAllocated;
    }

    public ApiImpalaUtilization utilizedAtMaxAllocatedPercentage(BigDecimal utilizedAtMaxAllocatedPercentage) {
        this.utilizedAtMaxAllocatedPercentage = utilizedAtMaxAllocatedPercentage;
        return this;
    }

    @Schema(description="The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.")
    public BigDecimal getUtilizedAtMaxAllocatedPercentage() {
        return this.utilizedAtMaxAllocatedPercentage;
    }

    public void setUtilizedAtMaxAllocatedPercentage(BigDecimal utilizedAtMaxAllocatedPercentage) {
        this.utilizedAtMaxAllocatedPercentage = utilizedAtMaxAllocatedPercentage;
    }

    public ApiImpalaUtilization peakUsageTimestampMS(BigDecimal peakUsageTimestampMS) {
        this.peakUsageTimestampMS = peakUsageTimestampMS;
        return this;
    }

    @Schema(description="The time when Impala used the maximum amount of memory for queries.")
    public BigDecimal getPeakUsageTimestampMS() {
        return this.peakUsageTimestampMS;
    }

    public void setPeakUsageTimestampMS(BigDecimal peakUsageTimestampMS) {
        this.peakUsageTimestampMS = peakUsageTimestampMS;
    }

    public ApiImpalaUtilization maxUtilizedMemory(BigDecimal maxUtilizedMemory) {
        this.maxUtilizedMemory = maxUtilizedMemory;
        return this;
    }

    @Schema(description="The maximum memory (in bytes) that was used by Impala for executing queries.")
    public BigDecimal getMaxUtilizedMemory() {
        return this.maxUtilizedMemory;
    }

    public void setMaxUtilizedMemory(BigDecimal maxUtilizedMemory) {
        this.maxUtilizedMemory = maxUtilizedMemory;
    }

    public ApiImpalaUtilization maxUtilizedMemoryPercentage(BigDecimal maxUtilizedMemoryPercentage) {
        this.maxUtilizedMemoryPercentage = maxUtilizedMemoryPercentage;
        return this;
    }

    @Schema(description="The maximum percentage of memory that was used by Impala for executing queries.")
    public BigDecimal getMaxUtilizedMemoryPercentage() {
        return this.maxUtilizedMemoryPercentage;
    }

    public void setMaxUtilizedMemoryPercentage(BigDecimal maxUtilizedMemoryPercentage) {
        this.maxUtilizedMemoryPercentage = maxUtilizedMemoryPercentage;
    }

    public ApiImpalaUtilization allocatedAtMaxUtilized(BigDecimal allocatedAtMaxUtilized) {
        this.allocatedAtMaxUtilized = allocatedAtMaxUtilized;
        return this;
    }

    @Schema(description="The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.")
    public BigDecimal getAllocatedAtMaxUtilized() {
        return this.allocatedAtMaxUtilized;
    }

    public void setAllocatedAtMaxUtilized(BigDecimal allocatedAtMaxUtilized) {
        this.allocatedAtMaxUtilized = allocatedAtMaxUtilized;
    }

    public ApiImpalaUtilization allocatedAtMaxUtilizedPercentage(BigDecimal allocatedAtMaxUtilizedPercentage) {
        this.allocatedAtMaxUtilizedPercentage = allocatedAtMaxUtilizedPercentage;
        return this;
    }

    @Schema(description="The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.")
    public BigDecimal getAllocatedAtMaxUtilizedPercentage() {
        return this.allocatedAtMaxUtilizedPercentage;
    }

    public void setAllocatedAtMaxUtilizedPercentage(BigDecimal allocatedAtMaxUtilizedPercentage) {
        this.allocatedAtMaxUtilizedPercentage = allocatedAtMaxUtilizedPercentage;
    }

    public ApiImpalaUtilization distributionUtilizedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon) {
        this.distributionUtilizedByImpalaDaemon = distributionUtilizedByImpalaDaemon;
        return this;
    }

    @Schema(description="")
    public ApiImpalaUtilizationHistogram getDistributionUtilizedByImpalaDaemon() {
        return this.distributionUtilizedByImpalaDaemon;
    }

    public void setDistributionUtilizedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon) {
        this.distributionUtilizedByImpalaDaemon = distributionUtilizedByImpalaDaemon;
    }

    public ApiImpalaUtilization distributionAllocatedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon) {
        this.distributionAllocatedByImpalaDaemon = distributionAllocatedByImpalaDaemon;
        return this;
    }

    @Schema(description="")
    public ApiImpalaUtilizationHistogram getDistributionAllocatedByImpalaDaemon() {
        return this.distributionAllocatedByImpalaDaemon;
    }

    public void setDistributionAllocatedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon) {
        this.distributionAllocatedByImpalaDaemon = distributionAllocatedByImpalaDaemon;
    }

    public ApiImpalaUtilization tenantUtilizations(ApiImpalaTenantUtilizationList tenantUtilizations) {
        this.tenantUtilizations = tenantUtilizations;
        return this;
    }

    @Schema(description="")
    public ApiImpalaTenantUtilizationList getTenantUtilizations() {
        return this.tenantUtilizations;
    }

    public void setTenantUtilizations(ApiImpalaTenantUtilizationList tenantUtilizations) {
        this.tenantUtilizations = tenantUtilizations;
    }

    public ApiImpalaUtilization errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(description="error message of utilization report.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiImpalaUtilization apiImpalaUtilization = (ApiImpalaUtilization)o;
        return Objects.equals(this.totalQueries, apiImpalaUtilization.totalQueries) && Objects.equals(this.successfulQueries, apiImpalaUtilization.successfulQueries) && Objects.equals(this.oomQueries, apiImpalaUtilization.oomQueries) && Objects.equals(this.timeOutQueries, apiImpalaUtilization.timeOutQueries) && Objects.equals(this.rejectedQueries, apiImpalaUtilization.rejectedQueries) && Objects.equals(this.successfulQueriesPercentage, apiImpalaUtilization.successfulQueriesPercentage) && Objects.equals(this.oomQueriesPercentage, apiImpalaUtilization.oomQueriesPercentage) && Objects.equals(this.timeOutQueriesPercentage, apiImpalaUtilization.timeOutQueriesPercentage) && Objects.equals(this.rejectedQueriesPercentage, apiImpalaUtilization.rejectedQueriesPercentage) && Objects.equals(this.avgWaitTimeInQueue, apiImpalaUtilization.avgWaitTimeInQueue) && Objects.equals(this.peakAllocationTimestampMS, apiImpalaUtilization.peakAllocationTimestampMS) && Objects.equals(this.maxAllocatedMemory, apiImpalaUtilization.maxAllocatedMemory) && Objects.equals(this.maxAllocatedMemoryPercentage, apiImpalaUtilization.maxAllocatedMemoryPercentage) && Objects.equals(this.utilizedAtMaxAllocated, apiImpalaUtilization.utilizedAtMaxAllocated) && Objects.equals(this.utilizedAtMaxAllocatedPercentage, apiImpalaUtilization.utilizedAtMaxAllocatedPercentage) && Objects.equals(this.peakUsageTimestampMS, apiImpalaUtilization.peakUsageTimestampMS) && Objects.equals(this.maxUtilizedMemory, apiImpalaUtilization.maxUtilizedMemory) && Objects.equals(this.maxUtilizedMemoryPercentage, apiImpalaUtilization.maxUtilizedMemoryPercentage) && Objects.equals(this.allocatedAtMaxUtilized, apiImpalaUtilization.allocatedAtMaxUtilized) && Objects.equals(this.allocatedAtMaxUtilizedPercentage, apiImpalaUtilization.allocatedAtMaxUtilizedPercentage) && Objects.equals(this.distributionUtilizedByImpalaDaemon, apiImpalaUtilization.distributionUtilizedByImpalaDaemon) && Objects.equals(this.distributionAllocatedByImpalaDaemon, apiImpalaUtilization.distributionAllocatedByImpalaDaemon) && Objects.equals(this.tenantUtilizations, apiImpalaUtilization.tenantUtilizations) && Objects.equals(this.errorMessage, apiImpalaUtilization.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.totalQueries, this.successfulQueries, this.oomQueries, this.timeOutQueries, this.rejectedQueries, this.successfulQueriesPercentage, this.oomQueriesPercentage, this.timeOutQueriesPercentage, this.rejectedQueriesPercentage, this.avgWaitTimeInQueue, this.peakAllocationTimestampMS, this.maxAllocatedMemory, this.maxAllocatedMemoryPercentage, this.utilizedAtMaxAllocated, this.utilizedAtMaxAllocatedPercentage, this.peakUsageTimestampMS, this.maxUtilizedMemory, this.maxUtilizedMemoryPercentage, this.allocatedAtMaxUtilized, this.allocatedAtMaxUtilizedPercentage, this.distributionUtilizedByImpalaDaemon, this.distributionAllocatedByImpalaDaemon, this.tenantUtilizations, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiImpalaUtilization {\n");
        sb.append("    totalQueries: ").append(this.toIndentedString(this.totalQueries)).append("\n");
        sb.append("    successfulQueries: ").append(this.toIndentedString(this.successfulQueries)).append("\n");
        sb.append("    oomQueries: ").append(this.toIndentedString(this.oomQueries)).append("\n");
        sb.append("    timeOutQueries: ").append(this.toIndentedString(this.timeOutQueries)).append("\n");
        sb.append("    rejectedQueries: ").append(this.toIndentedString(this.rejectedQueries)).append("\n");
        sb.append("    successfulQueriesPercentage: ").append(this.toIndentedString(this.successfulQueriesPercentage)).append("\n");
        sb.append("    oomQueriesPercentage: ").append(this.toIndentedString(this.oomQueriesPercentage)).append("\n");
        sb.append("    timeOutQueriesPercentage: ").append(this.toIndentedString(this.timeOutQueriesPercentage)).append("\n");
        sb.append("    rejectedQueriesPercentage: ").append(this.toIndentedString(this.rejectedQueriesPercentage)).append("\n");
        sb.append("    avgWaitTimeInQueue: ").append(this.toIndentedString(this.avgWaitTimeInQueue)).append("\n");
        sb.append("    peakAllocationTimestampMS: ").append(this.toIndentedString(this.peakAllocationTimestampMS)).append("\n");
        sb.append("    maxAllocatedMemory: ").append(this.toIndentedString(this.maxAllocatedMemory)).append("\n");
        sb.append("    maxAllocatedMemoryPercentage: ").append(this.toIndentedString(this.maxAllocatedMemoryPercentage)).append("\n");
        sb.append("    utilizedAtMaxAllocated: ").append(this.toIndentedString(this.utilizedAtMaxAllocated)).append("\n");
        sb.append("    utilizedAtMaxAllocatedPercentage: ").append(this.toIndentedString(this.utilizedAtMaxAllocatedPercentage)).append("\n");
        sb.append("    peakUsageTimestampMS: ").append(this.toIndentedString(this.peakUsageTimestampMS)).append("\n");
        sb.append("    maxUtilizedMemory: ").append(this.toIndentedString(this.maxUtilizedMemory)).append("\n");
        sb.append("    maxUtilizedMemoryPercentage: ").append(this.toIndentedString(this.maxUtilizedMemoryPercentage)).append("\n");
        sb.append("    allocatedAtMaxUtilized: ").append(this.toIndentedString(this.allocatedAtMaxUtilized)).append("\n");
        sb.append("    allocatedAtMaxUtilizedPercentage: ").append(this.toIndentedString(this.allocatedAtMaxUtilizedPercentage)).append("\n");
        sb.append("    distributionUtilizedByImpalaDaemon: ").append(this.toIndentedString(this.distributionUtilizedByImpalaDaemon)).append("\n");
        sb.append("    distributionAllocatedByImpalaDaemon: ").append(this.toIndentedString(this.distributionAllocatedByImpalaDaemon)).append("\n");
        sb.append("    tenantUtilizations: ").append(this.toIndentedString(this.tenantUtilizations)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

