/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="A metric schema represents the schema for a specific metric monitored by the Cloudera Management Services.")
public class ApiMetricSchema {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="isCounter")
    private Boolean isCounter = null;
    @SerializedName(value="unitNumerator")
    private String unitNumerator = null;
    @SerializedName(value="unitDenominator")
    private String unitDenominator = null;
    @SerializedName(value="aliases")
    private List<String> aliases = null;
    @SerializedName(value="sources")
    private Map<String, List<String>> sources = null;

    public ApiMetricSchema name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the metric. This name is guaranteed to be unique among the metrics.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiMetricSchema displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Display name of the metric.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiMetricSchema description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the metric.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiMetricSchema isCounter(Boolean isCounter) {
        this.isCounter = isCounter;
        return this;
    }

    @Schema(description="Is the metric a counter. A counter tracks the total count since a process / host started. The rate of change of a counter may often be more interesting than the raw value of a counter.")
    public Boolean isIsCounter() {
        return this.isCounter;
    }

    public void setIsCounter(Boolean isCounter) {
        this.isCounter = isCounter;
    }

    public ApiMetricSchema unitNumerator(String unitNumerator) {
        this.unitNumerator = unitNumerator;
        return this;
    }

    @Schema(description="Numerator for the unit of the metric.")
    public String getUnitNumerator() {
        return this.unitNumerator;
    }

    public void setUnitNumerator(String unitNumerator) {
        this.unitNumerator = unitNumerator;
    }

    public ApiMetricSchema unitDenominator(String unitDenominator) {
        this.unitDenominator = unitDenominator;
        return this;
    }

    @Schema(description="Denominator for the unit of the metric.")
    public String getUnitDenominator() {
        return this.unitDenominator;
    }

    public void setUnitDenominator(String unitDenominator) {
        this.unitDenominator = unitDenominator;
    }

    public ApiMetricSchema aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public ApiMetricSchema addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Schema(description="Aliases for the metric. An alias is unique per metric (per source and version) but is not globally unique. Aliases usually refer to previous names for the metric as metrics are renamed or replaced.")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public ApiMetricSchema sources(Map<String, List<String>> sources) {
        this.sources = sources;
        return this;
    }

    public ApiMetricSchema putSourcesItem(String key, List<String> sourcesItem) {
        if (this.sources == null) {
            this.sources = new HashMap<String, List<String>>();
        }
        this.sources.put(key, sourcesItem);
        return this;
    }

    @Schema(description="Sources for the metric. Each source entry contains the name of the source and a list of versions for which this source is valid")
    public Map<String, List<String>> getSources() {
        return this.sources;
    }

    public void setSources(Map<String, List<String>> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiMetricSchema apiMetricSchema = (ApiMetricSchema)o;
        return Objects.equals(this.name, apiMetricSchema.name) && Objects.equals(this.displayName, apiMetricSchema.displayName) && Objects.equals(this.description, apiMetricSchema.description) && Objects.equals(this.isCounter, apiMetricSchema.isCounter) && Objects.equals(this.unitNumerator, apiMetricSchema.unitNumerator) && Objects.equals(this.unitDenominator, apiMetricSchema.unitDenominator) && Objects.equals(this.aliases, apiMetricSchema.aliases) && Objects.equals(this.sources, apiMetricSchema.sources);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.isCounter, this.unitNumerator, this.unitDenominator, this.aliases, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiMetricSchema {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isCounter: ").append(this.toIndentedString(this.isCounter)).append("\n");
        sb.append("    unitNumerator: ").append(this.toIndentedString(this.unitNumerator)).append("\n");
        sb.append("    unitDenominator: ").append(this.toIndentedString(this.unitDenominator)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

