/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.icons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class LineIconFactory {
    private static final Logger logger = LogManager.getLogger(LineIconFactory.class);

    private LineIconFactory() {
    }

    public static Icon createExpandIcon() {
        int size = 8;
        int xOffSet = 0;
        int yOffSet = 0;
        try {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            BufferedImage image = new BufferedImage(size, size, 2);
            Graphics2D g2D = environment.createGraphics(image);
            g2D.setBackground(new Color(0, 0, 0, 0));
            g2D.clearRect(0, 0, size, size);
            g2D.setStroke(new BasicStroke(1.5f));
            g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2D.setColor(Color.black);
            g2D.drawLine(xOffSet, size / 2 + yOffSet, size - xOffSet, size / 2 + yOffSet);
            g2D.drawLine(xOffSet + size / 2, yOffSet, xOffSet + size / 2, size + yOffSet);
            return new ImageIcon(image);
        }
        catch (Exception e) {
            logger.error((Object)"failed to create a Expand icon", (Throwable)e);
            return null;
        }
    }

    public static Icon createCollapseIcon() {
        int size = 8;
        int xOffSet = 0;
        int yOffSet = 0;
        try {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            BufferedImage image = new BufferedImage(size, size, 2);
            Graphics2D g2D = environment.createGraphics(image);
            g2D.setBackground(new Color(0, 0, 0, 0));
            g2D.clearRect(0, 0, size, size);
            g2D.setStroke(new BasicStroke(1.5f));
            g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2D.setColor(Color.black);
            g2D.drawLine(xOffSet, size / 2 + yOffSet, size - xOffSet, size / 2 + yOffSet);
            return new ImageIcon(image);
        }
        catch (Exception e) {
            logger.error((Object)"failed to create a Collapse icon", (Throwable)e);
            return null;
        }
    }

    public static Icon createCloseIcon() {
        return new CloseIcon(8, 0, 0);
    }

    public static Icon createBlankIcon() {
        return new BlankIcon(16);
    }

    private static class CloseIcon
    implements Icon {
        int size;
        int xOffSet;
        int yOffSet;

        public CloseIcon(int size, int xOffSet, int yOffSet) {
            this.size = size;
            this.xOffSet = xOffSet;
            this.yOffSet = yOffSet;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setStroke(new BasicStroke(1.5f));
            g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2D.setColor(Color.black);
            g2D.drawLine(x + this.xOffSet, y + this.yOffSet, x + this.size + this.xOffSet, y + this.size + this.yOffSet);
            g2D.drawLine(x + this.xOffSet, y + this.size + this.yOffSet, x + this.size + this.xOffSet, y + this.yOffSet);
        }
    }

    private static class BlankIcon
    implements Icon {
        int size;

        public BlankIcon(int size) {
            this.size = size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

