/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class XMLSocketNode
extends ComponentBase
implements Runnable {
    Socket socket;
    Receiver receiver;
    Decoder decoder;
    SocketNodeEventListener listener;

    public XMLSocketNode(String decoder, Socket socket, LoggerRepository hierarchy) {
        this.repository = hierarchy;
        try {
            Class<?> c = Class.forName(decoder);
            Object o = c.newInstance();
            if (o instanceof Decoder) {
                this.decoder = (Decoder)o;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().warn((Object)"Unable to find decoder", cnfe);
        }
        catch (IllegalAccessException | InstantiationException iae) {
            this.getLogger().warn((Object)"Unable to construct decoder", iae);
        }
        this.socket = socket;
    }

    public XMLSocketNode(String decoder, Socket socket, Receiver receiver) {
        try {
            Class<?> c = Class.forName(decoder);
            Object o = c.newInstance();
            if (o instanceof Decoder) {
                this.decoder = (Decoder)o;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().warn((Object)"Unable to find decoder", cnfe);
        }
        catch (IllegalAccessException | InstantiationException iae) {
            this.getLogger().warn((Object)"Unable to construct decoder", iae);
        }
        this.socket = socket;
        this.receiver = receiver;
    }

    public void setListener(SocketNodeEventListener _listener) {
        this.listener = _listener;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        listenerException = null;
        if (this.receiver == null || this.decoder == null) {
            listenerException = new Exception("No receiver or decoder provided.  Cannot process xml socket events");
            this.getLogger().error((Object)"Exception constructing XML Socket Receiver", listenerException);
        }
        try {
            is = this.socket.getInputStream();
        }
        catch (Exception e) {
            is = null;
            listenerException = e;
            this.getLogger().error((Object)("Exception opening InputStream to " + this.socket), e);
        }
        if (is != null) {
            hostName = this.socket.getInetAddress().getHostName();
            remoteInfo = hostName + ":" + this.socket.getPort();
            try {
                block9: while (true) {
                    if ((length = is.read(b = new byte[1024])) == -1) {
                        this.getLogger().info("no bytes read from stream - closing connection.");
                        break;
                    }
                    v = this.decoder.decodeEvents(new String(b, 0, length));
                    if (v == null) continue;
                    var9_15 = v.iterator();
                    while (true) {
                        if (var9_15.hasNext()) ** break;
                        continue block9;
                        aV = var9_15.next();
                        e = (LoggingEvent)aV;
                        e.setProperty("hostname", hostName);
                        e.setProperty("log4j.remoteSourceInfo", remoteInfo);
                        if (this.receiver != null) {
                            this.receiver.doPost(e);
                            continue;
                        }
                        remoteLogger = this.repository.getLogger(e.getLoggerName());
                        if (!e.getLevel().isGreaterOrEqual((Priority)remoteLogger.getEffectiveLevel())) continue;
                        remoteLogger.callAppenders(e);
                    }
                    break;
                }
            }
            catch (EOFException e) {
                this.getLogger().info("Caught java.io.EOFException closing connection.");
                listenerException = e;
            }
            catch (SocketException e) {
                this.getLogger().info("Caught java.net.SocketException closing connection.");
                listenerException = e;
            }
            catch (IOException e) {
                this.getLogger().info("Caught java.io.IOException: " + e);
                this.getLogger().info("Closing connection.");
                listenerException = e;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Unexpected exception. Closing connection.", e);
                listenerException = e;
            }
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception var4_5) {
            // empty catch block
        }
        if (this.listener != null) {
            this.listener.socketClosedEvent(listenerException);
        }
    }
}

