/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.EventAttribute;
import org.apache.logging.log4j.catalog.api.exception.CatalogModificationException;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.EventAttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.service.AttributeService;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.apache.logging.log4j.util.Supplier;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConverter
extends AbstractConverter<Event, EventModel> {
    private static Logger LOGGER = LogManager.getLogger(EventConverter.class);
    @Autowired
    private EventService eventService;
    @Autowired
    private AttributeService attributeService;

    public EventModel convert(Event event) {
        List eventAttributes;
        LOGGER.traceEntry(event.getName(), new Supplier[0]);
        EventModel model = event.getId() != null ? this.eventService.getEvent(event.getId()).orElseGet(EventModel::new) : new EventModel();
        model.setCatalogId(event.getCatalogId());
        model.setName(event.getName());
        model.setAliases(event.getAliases());
        model.setDescription(event.getDescription());
        model.setDisplayName(event.getDisplayName());
        if (model.getAttributes() == null) {
            model.setAttributes(new HashSet<EventAttributeModel>());
        }
        HashSet<EventAttributeModel> eventAttributeModels = model.getAttributes() != null ? model.getAttributes() : new HashSet<EventAttributeModel>();
        List list = eventAttributes = event.getAttributes() != null ? event.getAttributes() : new ArrayList();
        if (event.getAttributes() != null) {
            for (EventAttribute eventAttribute : eventAttributes) {
                EventAttributeModel eventAttributeModel = model.getAttribute(eventAttribute.getName());
                if (eventAttributeModel != null) {
                    eventAttributeModel.setRequired(eventAttribute != null ? eventAttribute.isRequired() : null);
                    continue;
                }
                Optional<AttributeModel> optional = this.getAttribute(event.getCatalogId(), eventAttribute.getName());
                if (optional.isPresent()) {
                    eventAttributeModel = new EventAttributeModel();
                    if (eventAttribute != null) {
                        eventAttributeModel.setRequired(eventAttribute.isRequired());
                    }
                    eventAttributeModel.setEvent(model);
                    eventAttributeModel.setAttribute(optional.get());
                    eventAttributeModels.add(eventAttributeModel);
                    continue;
                }
                throw new CatalogModificationException("No catalog entry for " + eventAttribute.getName());
            }
        }
        eventAttributeModels.removeIf(a -> eventAttributes.stream().noneMatch(b -> b.getName().equals(a.getAttribute().getName())));
        model.setAttributes(eventAttributeModels);
        return (EventModel)LOGGER.traceExit((Object)model);
    }

    private Optional<AttributeModel> getAttribute(String catalogId, String name) {
        Optional<AttributeModel> optional = this.attributeService.getAttribute(catalogId, name);
        if (!optional.isPresent()) {
            optional = this.attributeService.getAttribute("DEFAULT", name);
        }
        return optional;
    }
}

