/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.exporter.MetricsQueryTemplate;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetricsConfiguration {
    private final PrometheusExporterSettings settings;
    private final List<MetricsQuery> pingConfiguration;
    private final List<MetricsQuery> metricsConfiguration;
    private final List<MetricsQuery> collectionsConfiguration;
    private final List<MetricsQuery> searchConfiguration;

    private MetricsConfiguration(PrometheusExporterSettings settings, List<MetricsQuery> pingConfiguration, List<MetricsQuery> metricsConfiguration, List<MetricsQuery> collectionsConfiguration, List<MetricsQuery> searchConfiguration) {
        this.settings = settings;
        this.pingConfiguration = pingConfiguration;
        this.metricsConfiguration = metricsConfiguration;
        this.collectionsConfiguration = collectionsConfiguration;
        this.searchConfiguration = searchConfiguration;
    }

    public static MetricsConfiguration from(XmlConfigFile config) throws Exception {
        Node settings = config.getNode("/config/settings", false);
        NodeList jqTemplates = config.getNodeList("/config/jq-templates/template", false);
        Map<String, MetricsQueryTemplate> jqTemplatesMap = jqTemplates != null && jqTemplates.getLength() > 0 ? MetricsConfiguration.loadJqTemplates(jqTemplates) : Collections.emptyMap();
        Node pingConfig = config.getNode("/config/rules/ping", false);
        Node metricsConfig = config.getNode("/config/rules/metrics", false);
        Node collectionsConfig = config.getNode("/config/rules/collections", false);
        Node searchConfiguration = config.getNode("/config/rules/search", false);
        return new MetricsConfiguration(settings == null ? PrometheusExporterSettings.builder().build() : PrometheusExporterSettings.from(settings), MetricsConfiguration.toMetricQueries(pingConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(metricsConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(collectionsConfig, jqTemplatesMap), MetricsConfiguration.toMetricQueries(searchConfiguration, jqTemplatesMap));
    }

    private static List<MetricsQuery> toMetricQueries(Node node, Map<String, MetricsQueryTemplate> jqTemplatesMap) throws JsonQueryException {
        if (node == null) {
            return Collections.emptyList();
        }
        return MetricsQuery.from(node, jqTemplatesMap);
    }

    static Map<String, MetricsQueryTemplate> loadJqTemplates(NodeList jqTemplates) {
        HashMap<String, MetricsQueryTemplate> map = new HashMap<String, MetricsQueryTemplate>();
        for (int t = 0; t < jqTemplates.getLength(); ++t) {
            Node template = jqTemplates.item(t);
            if (template.getNodeType() != 1 || !template.hasAttributes()) continue;
            Node nameAttr = template.getAttributes().getNamedItem("name");
            String name = nameAttr != null ? nameAttr.getNodeValue() : null;
            String tmpl = template.getTextContent();
            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)tmpl)) continue;
            Node defaultTypeAttr = template.getAttributes().getNamedItem("defaultType");
            String defaultType = defaultTypeAttr != null ? defaultTypeAttr.getNodeValue() : null;
            map.put(name, new MetricsQueryTemplate(name, tmpl, defaultType));
        }
        return map;
    }

    public PrometheusExporterSettings getSettings() {
        return this.settings;
    }

    public List<MetricsQuery> getPingConfiguration() {
        return this.pingConfiguration;
    }

    public List<MetricsQuery> getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public List<MetricsQuery> getCollectionsConfiguration() {
        return this.collectionsConfiguration;
    }

    public List<MetricsQuery> getSearchConfiguration() {
        return this.searchConfiguration;
    }
}

