/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.util.Properties;
import org.eigenbase.util.property.Property;

public class IntegerProperty
extends Property {
    private final int minValue;
    private final int maxValue;

    public IntegerProperty(Properties properties, String path, int defaultValue) {
        this(properties, path, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerProperty(Properties properties, String path) {
        this(properties, path, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerProperty(Properties properties, String path, int defaultValue, int minValue, int maxValue) {
        super(properties, path, Integer.toString(defaultValue));
        if (minValue > maxValue) {
            int temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("invalid default value " + defaultValue);
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public IntegerProperty(Properties properties, String path, int minValue, int maxValue) {
        super(properties, path, null);
        if (minValue > maxValue) {
            int temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int get() {
        String value = this.getInternal(null, false);
        if (value == null) {
            return this.noValue();
        }
        int v = Integer.parseInt(value);
        return this.limit(v);
    }

    public int get(int defaultValue) {
        String value = this.getInternal(Integer.toString(defaultValue), false);
        if (value == null) {
            return this.limit(defaultValue);
        }
        int v = Integer.parseInt(value);
        return this.limit(v);
    }

    public int set(int value) {
        String prevValue = this.setString(Integer.toString(this.limit(value)));
        if (prevValue == null && (prevValue = this.getDefaultValue()) == null) {
            return this.noValue();
        }
        int v = Integer.parseInt(prevValue);
        return this.limit(v);
    }

    private int limit(int value) {
        return Math.min(Math.max(value, this.minValue), this.maxValue);
    }

    private int noValue() {
        if (this.minValue <= 0 && this.maxValue >= 0) {
            return 0;
        }
        return this.minValue;
    }
}

