/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.cloud.autoscaling.sim.SimUtils;

public class SnapshotNodeStateProvider
implements NodeStateProvider {
    private Map<String, Map<String, Object>> nodeValues = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Map<String, List<ReplicaInfo>>>> replicaInfos = new LinkedHashMap<String, Map<String, Map<String, List<ReplicaInfo>>>>();
    private static double GB = 1.073741824E9;

    public SnapshotNodeStateProvider(SolrCloudManager other, AutoScalingConfig config) throws Exception {
        if (config == null) {
            config = other.getDistribStateManager().getAutoScalingConfig();
        }
        HashSet<String> nodeTags = new HashSet<String>(SimUtils.COMMON_NODE_TAGS);
        nodeTags.addAll(config.getPolicy().getParamNames());
        HashSet<String> replicaTags = new HashSet<String>(SimUtils.COMMON_REPLICA_TAGS);
        replicaTags.addAll(config.getPolicy().getPerReplicaAttributes());
        for (String node : other.getClusterStateProvider().getLiveNodes()) {
            this.nodeValues.put(node, new LinkedHashMap(other.getNodeStateProvider().getNodeValues(node, nodeTags)));
            Map infos = other.getNodeStateProvider().getReplicaInfo(node, replicaTags);
            infos.forEach((collection, shards) -> shards.forEach((shard, replicas) -> replicas.forEach(r -> {
                List myReplicas = this.replicaInfos.computeIfAbsent(node, n -> new LinkedHashMap()).computeIfAbsent(collection, c -> new LinkedHashMap()).computeIfAbsent(shard, s -> new ArrayList());
                LinkedHashMap rMap = new LinkedHashMap();
                r.toMap(rMap);
                if (r.isLeader) {
                    ((Map)rMap.values().iterator().next()).put("leader", "true");
                }
                ReplicaInfo ri = new ReplicaInfo(rMap);
                if (r.isLeader) {
                    ri.getVariables().put("leader", "true");
                }
                if (ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute) == null) {
                    if (ri.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
                        Number indexSizeGB = (Number)ri.getVariable(Variable.Type.CORE_IDX.tagName);
                        ri.getVariables().put(Variable.Type.CORE_IDX.metricsAttribute, indexSizeGB.doubleValue() * GB);
                    } else {
                        throw new RuntimeException("Missing size information for replica: " + ri);
                    }
                }
                myReplicas.add(ri);
            })));
        }
    }

    public SnapshotNodeStateProvider(Map<String, Object> snapshot) {
        Objects.requireNonNull(snapshot);
        this.nodeValues = snapshot.getOrDefault("nodeValues", Collections.emptyMap());
        snapshot.getOrDefault("replicaInfos", Collections.emptyMap()).forEach((node, v) -> {
            Map perNode = this.replicaInfos.computeIfAbsent((String)node, n -> new LinkedHashMap());
            ((Map)v).forEach((collection, shards) -> {
                Map perColl = perNode.computeIfAbsent(collection, c -> new LinkedHashMap());
                ((Map)shards).forEach((shard, replicas) -> {
                    List infos = perColl.computeIfAbsent(shard, s -> new ArrayList());
                    ((List)replicas).forEach(replicaMap -> {
                        ReplicaInfo ri = new ReplicaInfo(new LinkedHashMap(replicaMap));
                        if (ri.isLeader) {
                            ri.getVariables().put("leader", "true");
                        }
                        if (ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute) == null) {
                            if (ri.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
                                Number indexSizeGB = (Number)ri.getVariable(Variable.Type.CORE_IDX.tagName);
                                ri.getVariables().put(Variable.Type.CORE_IDX.metricsAttribute, indexSizeGB.doubleValue() * GB);
                            } else {
                                throw new RuntimeException("Missing size information for replica: " + ri);
                            }
                        }
                        infos.add(ri);
                    });
                });
            });
        });
    }

    public Map<String, Object> getSnapshot() {
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>();
        snapshot.put("nodeValues", this.nodeValues);
        LinkedHashMap replicaInfosMap = new LinkedHashMap();
        snapshot.put("replicaInfos", replicaInfosMap);
        this.replicaInfos.forEach((node, perNode) -> perNode.forEach((collection, shards) -> shards.forEach((shard, replicas) -> replicas.forEach(r -> {
            List myReplicas = replicaInfosMap.computeIfAbsent(node, n -> new LinkedHashMap()).computeIfAbsent(collection, c -> new LinkedHashMap()).computeIfAbsent(shard, s -> new ArrayList());
            LinkedHashMap rMap = new LinkedHashMap();
            r.toMap(rMap);
            if (r.isLeader) {
                ((Map)rMap.values().iterator().next()).put("leader", "true");
            }
            myReplicas.add(rMap);
        }))));
        return snapshot;
    }

    public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
        return new LinkedHashMap<String, Object>(this.nodeValues.getOrDefault(node, Collections.emptyMap()));
    }

    public Map<String, Map<String, List<ReplicaInfo>>> getReplicaInfo(String node, Collection<String> keys) {
        LinkedHashMap<String, Map<String, List<ReplicaInfo>>> result = new LinkedHashMap<String, Map<String, List<ReplicaInfo>>>();
        Map<String, Map> infos = this.replicaInfos.getOrDefault(node, Collections.emptyMap());
        infos.forEach((coll, shards) -> shards.forEach((shard, replicas) -> replicas.forEach(ri -> {
            List myReplicas = result.computeIfAbsent((String)coll, c -> new LinkedHashMap()).computeIfAbsent(shard, s -> new ArrayList());
            ReplicaInfo myReplica = (ReplicaInfo)ri.clone();
            myReplicas.add(myReplica);
        })));
        return result;
    }

    public ReplicaInfo getReplicaInfo(String collection, String coreNode) {
        for (Map<String, Map<String, List<ReplicaInfo>>> perNode : this.replicaInfos.values()) {
            for (List perShard : perNode.getOrDefault(collection, Collections.emptyMap()).values()) {
                for (ReplicaInfo ri : perShard) {
                    if (!ri.getName().equals(coreNode)) continue;
                    return (ReplicaInfo)ri.clone();
                }
            }
        }
        return null;
    }

    public void close() throws IOException {
    }
}

