/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import javax.annotation.Nullable;

final class AutoValue_ApiMethodDescriptor<RequestT, ResponseT>
extends ApiMethodDescriptor<RequestT, ResponseT> {
    private final String fullMethodName;
    private final HttpRequestFormatter<RequestT> requestFormatter;
    private final HttpResponseParser<ResponseT> responseParser;
    private final String httpMethod;

    private AutoValue_ApiMethodDescriptor(String fullMethodName, HttpRequestFormatter<RequestT> requestFormatter, @Nullable HttpResponseParser<ResponseT> responseParser, @Nullable String httpMethod) {
        this.fullMethodName = fullMethodName;
        this.requestFormatter = requestFormatter;
        this.responseParser = responseParser;
        this.httpMethod = httpMethod;
    }

    @Override
    public String getFullMethodName() {
        return this.fullMethodName;
    }

    @Override
    public HttpRequestFormatter<RequestT> getRequestFormatter() {
        return this.requestFormatter;
    }

    @Override
    @Nullable
    public HttpResponseParser<ResponseT> getResponseParser() {
        return this.responseParser;
    }

    @Override
    @Nullable
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        return "ApiMethodDescriptor{fullMethodName=" + this.fullMethodName + ", requestFormatter=" + this.requestFormatter + ", responseParser=" + this.responseParser + ", httpMethod=" + this.httpMethod + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ApiMethodDescriptor) {
            ApiMethodDescriptor that = (ApiMethodDescriptor)o;
            return this.fullMethodName.equals(that.getFullMethodName()) && this.requestFormatter.equals(that.getRequestFormatter()) && (this.responseParser == null ? that.getResponseParser() == null : this.responseParser.equals(that.getResponseParser())) && (this.httpMethod == null ? that.getHttpMethod() == null : this.httpMethod.equals(that.getHttpMethod()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.fullMethodName.hashCode();
        h *= 1000003;
        h ^= this.requestFormatter.hashCode();
        h *= 1000003;
        h ^= this.responseParser == null ? 0 : this.responseParser.hashCode();
        h *= 1000003;
        return h ^= this.httpMethod == null ? 0 : this.httpMethod.hashCode();
    }

    static final class Builder<RequestT, ResponseT>
    extends ApiMethodDescriptor.Builder<RequestT, ResponseT> {
        private String fullMethodName;
        private HttpRequestFormatter<RequestT> requestFormatter;
        private HttpResponseParser<ResponseT> responseParser;
        private String httpMethod;

        Builder() {
        }

        @Override
        public ApiMethodDescriptor.Builder<RequestT, ResponseT> setFullMethodName(String fullMethodName) {
            if (fullMethodName == null) {
                throw new NullPointerException("Null fullMethodName");
            }
            this.fullMethodName = fullMethodName;
            return this;
        }

        @Override
        public ApiMethodDescriptor.Builder<RequestT, ResponseT> setRequestFormatter(HttpRequestFormatter<RequestT> requestFormatter) {
            if (requestFormatter == null) {
                throw new NullPointerException("Null requestFormatter");
            }
            this.requestFormatter = requestFormatter;
            return this;
        }

        @Override
        public ApiMethodDescriptor.Builder<RequestT, ResponseT> setResponseParser(@Nullable HttpResponseParser<ResponseT> responseParser) {
            this.responseParser = responseParser;
            return this;
        }

        @Override
        public ApiMethodDescriptor.Builder<RequestT, ResponseT> setHttpMethod(@Nullable String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public ApiMethodDescriptor<RequestT, ResponseT> build() {
            String missing = "";
            if (this.fullMethodName == null) {
                missing = missing + " fullMethodName";
            }
            if (this.requestFormatter == null) {
                missing = missing + " requestFormatter";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ApiMethodDescriptor(this.fullMethodName, this.requestFormatter, this.responseParser, this.httpMethod);
        }
    }
}

