/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateWriter {
    private static final long MAX_FLUSH_INTERVAL = TimeUnit.NANOSECONDS.convert(Overseer.STATE_UPDATE_DELAY, TimeUnit.MILLISECONDS);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static ZkWriteCommand NO_OP = ZkWriteCommand.noop();
    protected final ZkStateReader reader;
    protected final Stats stats;
    protected Map<String, ZkWriteCommand> updates = new HashMap<String, ZkWriteCommand>();
    private int numUpdates = 0;
    protected ClusterState clusterState = null;
    protected boolean isClusterStateModified = false;
    protected long lastUpdatedTime = 0L;
    protected boolean invalidState = false;

    public ZkStateWriter(ZkStateReader zkStateReader, Stats stats) {
        assert (zkStateReader != null);
        this.reader = zkStateReader;
        this.stats = stats;
        this.clusterState = zkStateReader.getClusterState();
    }

    public void updateClusterState(Function<ClusterState, ClusterState> fun) {
        this.clusterState = fun.apply(this.clusterState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState enqueueUpdate(ClusterState prevState, List<ZkWriteCommand> cmds, ZkWriteCallback callback) throws IllegalStateException, Exception {
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (cmds.isEmpty()) {
            return prevState;
        }
        if (this.isNoOps(cmds)) {
            return prevState;
        }
        boolean forceFlush = false;
        if (cmds.size() == 1) {
            Iterator<ZkWriteCommand> cmd = cmds.get(0);
            if (((ZkWriteCommand)((Object)cmd)).collection != null && ((ZkWriteCommand)((Object)cmd)).collection.isPerReplicaState()) {
                if (this.updates.containsKey(((ZkWriteCommand)((Object)cmd)).name)) {
                    this.writeUpdate(this.updates.remove(((ZkWriteCommand)((Object)cmd)).name));
                }
                try {
                    ClusterState clusterState = this.writeUpdate((ZkWriteCommand)((Object)cmd));
                    return clusterState;
                }
                finally {
                    if (callback != null) {
                        callback.onWrite();
                    }
                }
            }
        } else {
            for (ZkWriteCommand cmd : cmds) {
                if (cmd.collection == null || !cmd.collection.isPerReplicaState()) continue;
                forceFlush = true;
                break;
            }
        }
        for (ZkWriteCommand cmd : cmds) {
            if (cmd == NO_OP) continue;
            if (!this.isClusterStateModified && this.clusterStateGetModifiedWith(cmd, prevState)) {
                this.isClusterStateModified = true;
            }
            prevState = prevState.copyWith(cmd.name, cmd.collection);
            if (cmd.collection != null && cmd.collection.getStateFormat() == 1) continue;
            this.updates.put(cmd.name, cmd);
            ++this.numUpdates;
        }
        this.clusterState = prevState;
        if (forceFlush || this.maybeFlushAfter()) {
            ClusterState state = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
            return state;
        }
        return this.clusterState;
    }

    private boolean isNoOps(List<ZkWriteCommand> cmds) {
        for (ZkWriteCommand cmd : cmds) {
            if (cmd == NO_OP) continue;
            return false;
        }
        return true;
    }

    private boolean clusterStateGetModifiedWith(ZkWriteCommand command, ClusterState state) {
        DocCollection previousCollection = state.getCollectionOrNull(command.name);
        boolean wasPreviouslyStateFormat1 = previousCollection != null && previousCollection.getStateFormat() == 1;
        boolean isCurrentlyStateFormat1 = command.collection != null && command.collection.getStateFormat() == 1;
        return wasPreviouslyStateFormat1 || isCurrentlyStateFormat1;
    }

    private boolean maybeFlushAfter() {
        return System.nanoTime() - this.lastUpdatedTime > MAX_FLUSH_INTERVAL || this.numUpdates > Overseer.STATE_UPDATE_BATCH_SIZE;
    }

    public boolean hasPendingUpdates() {
        return this.numUpdates != 0 || this.isClusterStateModified;
    }

    public ClusterState writeUpdate(ZkWriteCommand command) throws IllegalStateException, KeeperException, InterruptedException {
        HashMap<String, ZkWriteCommand> commands = new HashMap<String, ZkWriteCommand>();
        commands.put(command.name, command);
        return this.writePendingUpdates(commands);
    }

    public ClusterState writePendingUpdates() throws KeeperException, InterruptedException {
        return this.writePendingUpdates(this.updates);
    }

    public ClusterState writePendingUpdates(Map<String, ZkWriteCommand> updates) throws IllegalStateException, KeeperException, InterruptedException {
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (updates == this.updates && !this.hasPendingUpdates()) {
            return this.clusterState;
        }
        Timer.Context timerContext = this.stats.time("update_state");
        boolean success = false;
        try {
            if (!updates.isEmpty()) {
                for (Map.Entry<String, ZkWriteCommand> entry : updates.entrySet()) {
                    String name = entry.getKey();
                    String path = ZkStateReader.getCollectionPath((String)name);
                    ZkWriteCommand cmd = entry.getValue();
                    DocCollection c = cmd.collection;
                    if (cmd.ops != null && cmd.ops.isPreOp()) {
                        cmd.ops.persist(path, this.reader.getZkClient());
                        this.clusterState = this.clusterState.copyWith(name, cmd.collection.copyWith(PerReplicaStates.fetch((String)cmd.collection.getZNode(), (SolrZkClient)this.reader.getZkClient(), null)));
                    }
                    if (!cmd.persistCollState) continue;
                    if (c == null) {
                        log.debug("going to delete state.json {}", (Object)path);
                        this.reader.getZkClient().clean(path);
                    } else if (c.getStateFormat() > 1) {
                        byte[] data = Utils.toJSON(Collections.singletonMap(c.getName(), c));
                        if (this.reader.getZkClient().exists(path, true).booleanValue()) {
                            if (log.isDebugEnabled()) {
                                log.debug("going to update_collection {} version: {}", (Object)path, (Object)c.getZNodeVersion());
                            }
                            Stat stat = this.reader.getZkClient().setData(path, data, c.getZNodeVersion(), true);
                            DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), stat.getVersion(), path, (DocCollection.PrsSupplier)new PerReplicaStates.LazyPrsSupplier(this.reader.getZkClient(), path));
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                        } else {
                            log.debug("going to create_collection {}", (Object)path);
                            this.reader.getZkClient().create(path, data, CreateMode.PERSISTENT, true);
                            DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), 0, path, (DocCollection.PrsSupplier)new PerReplicaStates.LazyPrsSupplier(this.reader.getZkClient(), path));
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                        }
                    } else if (c.getStateFormat() == 1) {
                        this.isClusterStateModified = true;
                    }
                    if (cmd.ops == null || cmd.ops.isPreOp()) continue;
                    cmd.ops.persist(path, this.reader.getZkClient());
                    DocCollection currentCollState = this.clusterState.getCollection(cmd.name);
                    if (currentCollState == null) continue;
                    this.clusterState = this.clusterState.copyWith(name, currentCollState.copyWith(PerReplicaStates.fetch((String)currentCollState.getZNode(), (SolrZkClient)this.reader.getZkClient(), null)));
                }
                updates.clear();
                this.numUpdates = 0;
            }
            if (this.isClusterStateModified) {
                assert (this.clusterState.getZkClusterStateVersion() >= 0);
                byte[] data = Utils.toJSON((Object)this.clusterState);
                Stat stat = this.reader.getZkClient().setData("/clusterstate.json", data, this.clusterState.getZkClusterStateVersion().intValue(), true);
                Map collections = this.clusterState.getCollectionsMap();
                this.clusterState = new ClusterState(Integer.valueOf(stat.getVersion()), this.reader.getClusterState().getLiveNodes(), collections);
                this.isClusterStateModified = false;
            }
            this.lastUpdatedTime = System.nanoTime();
            success = true;
        }
        catch (KeeperException.BadVersionException bve) {
            this.invalidState = true;
            throw bve;
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success("update_state");
            } else {
                this.stats.error("update_state");
            }
        }
        log.trace("New Cluster State is: {}", (Object)this.clusterState);
        return this.clusterState;
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public static interface ZkWriteCallback {
        public void onWrite() throws Exception;
    }
}

