/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.TransientSolrCoreCacheFactoryDefault;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransientSolrCoreCacheFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile CoreContainer coreContainer = null;
    public static final PluginInfo DEFAULT_TRANSIENT_SOLR_CACHE_INFO = new PluginInfo("transientSolrCoreCacheFactory", (Map<String, String>)ImmutableMap.of((Object)"class", (Object)TransientSolrCoreCacheFactoryDefault.class.getName(), (Object)"name", (Object)TransientSolrCoreCacheFactory.class.getName()), null, Collections.emptyList());

    public abstract TransientSolrCoreCache getTransientSolrCoreCache();

    public static TransientSolrCoreCacheFactory newInstance(SolrResourceLoader loader, CoreContainer coreContainer) {
        PluginInfo info = coreContainer.getConfig().getTransientCachePluginInfo();
        if (info == null) {
            info = DEFAULT_TRANSIENT_SOLR_CACHE_INFO;
        }
        try {
            TransientSolrCoreCacheFactory tccf = loader.findClass(info.className, TransientSolrCoreCacheFactory.class).newInstance();
            if (PluginInfoInitialized.class.isAssignableFrom(tccf.getClass())) {
                ((PluginInfoInitialized)PluginInfoInitialized.class.cast(tccf)).init(info);
            }
            tccf.setCoreContainer(coreContainer);
            return tccf;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating " + TransientSolrCoreCacheFactory.class.getName() + " class [" + info.className + "]", (Throwable)e);
        }
    }

    public void setCoreContainer(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }
}

