/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LongStreamToDateParseFunction;
import org.apache.solr.analytics.function.mapping.LongToDateParseFunction;
import org.apache.solr.analytics.function.mapping.StringStreamToDateParseFunction;
import org.apache.solr.analytics.function.mapping.StringToDateParseFunction;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class DateParseFunction {
    public static final String name = "date";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date function requires 1 paramater, " + params.length + " found.");
        }
        if (params[0] instanceof LongValue) {
            return new LongToDateParseFunction((LongValue)params[0]);
        }
        if (params[0] instanceof LongValueStream) {
            return new LongStreamToDateParseFunction((LongValueStream)params[0]);
        }
        if (params[0] instanceof StringValue) {
            return new StringToDateParseFunction((StringValue)params[0]);
        }
        if (params[0] instanceof StringValueStream) {
            return new StringStreamToDateParseFunction((StringValueStream)params[0]);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date function requires a string or long parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };
}

