/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

final class CharSequenceConverter<T>
extends SystemConverter<CharSequence, T> {
    private static final long serialVersionUID = -2853169224777674260L;
    private final ObjectConverter<? super String, ? extends T> next;

    CharSequenceConverter(Class<T> clazz, ObjectConverter<? super String, ? extends T> objectConverter) {
        super(CharSequence.class, clazz);
        this.next = objectConverter;
    }

    @Override
    public T apply(CharSequence charSequence) throws UnconvertibleObjectException {
        if (this.targetClass.isInstance(charSequence)) {
            return this.targetClass.cast(charSequence);
        }
        return this.next.apply(charSequence != null ? charSequence.toString() : null);
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> enumSet = EnumSet.copyOf(this.next.properties());
        enumSet.remove((Object)FunctionProperty.INJECTIVE);
        return enumSet;
    }
}

