/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.query;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.inmemory.query.PropertyQueryUtil;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.AbstractPredicateWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisSelector;
import org.apache.chemistry.opencmis.server.support.query.ColumnReference;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;
import org.apache.chemistry.opencmis.server.support.query.QueryUtilStrict;
import org.apache.chemistry.opencmis.server.support.query.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryQueryProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryQueryProcessor.class);
    private List<StoredObject> matches = new ArrayList<StoredObject>();
    private QueryObject queryObj;
    private Tree whereTree;
    private ObjectStoreImpl objStore;
    private List<TypeDefinition> secondaryTypeIds;
    private CallContext callContext;
    private boolean relaxedParserMode;

    public InMemoryQueryProcessor(ObjectStoreImpl objStore, CallContext ctx, boolean relaxedParserMode) {
        this.objStore = objStore;
        this.callContext = ctx;
        this.relaxedParserMode = relaxedParserMode;
    }

    public ObjectList query(TypeManager tm, ObjectStore objectStore, String user, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        this.processQueryAndCatchExc(statement, tm);
        for (String objectId : ((ObjectStoreImpl)objectStore).getIds()) {
            StoredObject so = objectStore.getObjectById(objectId);
            this.match(so, user, searchAllVersions == null ? true : searchAllVersions);
        }
        ObjectList objList = this.buildResultList(tm, user, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        LOG.debug("Query result, number of matching objects: " + objList.getNumItems());
        return objList;
    }

    public void processQueryAndCatchExc(String statement, TypeManager tm) {
        QueryUtilStrict queryUtil = this.relaxedParserMode ? new QueryUtilStrict(statement, tm, null, true, QueryObject.ParserMode.MODE_ALLOW_RELAXED_SELECT) : new QueryUtilStrict(statement, tm, null);
        queryUtil.processStatementUsingCmisExceptions();
        CmisQueryWalker walker = (CmisQueryWalker)queryUtil.getWalker();
        this.queryObj = queryUtil.getQueryObject();
        this.whereTree = walker.getWherePredicateTree();
        this.secondaryTypeIds = this.queryObj.getJoinedSecondaryTypes();
        this.doAdditionalChecks(walker);
    }

    public ObjectList buildResultList(TypeManager tm, String user, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        this.sortMatches();
        ObjectListImpl res = new ObjectListImpl();
        res.setNumItems(BigInteger.valueOf(this.matches.size()));
        int start = 0;
        if (skipCount != null) {
            start = (int)skipCount.longValue();
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.matches.size()) {
            start = this.matches.size();
        }
        int stop = 0;
        if (maxItems != null) {
            stop = start + (int)maxItems.longValue();
        }
        if (stop <= 0 || stop > this.matches.size()) {
            stop = this.matches.size();
        }
        res.setHasMoreItems(Boolean.valueOf(stop < this.matches.size()));
        if (start > 0 || stop > 0) {
            this.matches = this.matches.subList(start, stop);
        }
        ArrayList<ObjectData> objDataList = new ArrayList<ObjectData>();
        Map props = this.queryObj.getRequestedPropertiesByAlias();
        Map funcs = this.queryObj.getRequestedFuncsByAlias();
        for (StoredObject so : this.matches) {
            String queryName = (String)this.queryObj.getTypes().values().iterator().next();
            TypeDefinition td = this.queryObj.getTypeDefinitionFromQueryName(queryName);
            ObjectData od = PropertyCreationHelper.getObjectDataQueryResult(this.callContext, tm, this.objStore, td, so, user, props, funcs, this.secondaryTypeIds, includeAllowableActions, includeRelationships, renditionFilter);
            objDataList.add(od);
        }
        res.setObjects(objDataList);
        return res;
    }

    private boolean typeMatches(TypeDefinition td, StoredObject so) {
        String typeId = so.getTypeId();
        while (typeId != null) {
            if (typeId.equals(td.getId())) {
                return true;
            }
            List<String> secTypeIds = so.getSecondaryTypeIds();
            for (String secTypeId : secTypeIds) {
                if (!secTypeId.equals(td.getId())) continue;
                return true;
            }
            TypeDefinition parentTD = this.queryObj.getParentType(typeId);
            typeId = parentTD == null ? null : parentTD.getId();
        }
        return false;
    }

    private void sortMatches() {
        final List orderBy = this.queryObj.getOrderBys();
        if (orderBy.size() > 1) {
            LOG.warn("ORDER BY has more than one sort criterium, all but the first are ignored.");
        }
        if (orderBy.size() > 0) {
            class ResultComparator
            implements Comparator<StoredObject> {
                ResultComparator() {
                }

                @Override
                public int compare(StoredObject so1, StoredObject so2) {
                    int result;
                    QueryObject.SortSpec s = (QueryObject.SortSpec)orderBy.get(0);
                    CmisSelector sel = s.getSelector();
                    if (InMemoryQueryProcessor.this.queryObj.isPredfinedQueryName(sel.getName())) {
                        result = 0;
                    } else if (sel instanceof ColumnReference) {
                        String propId = ((ColumnReference)sel).getPropertyId();
                        PropertyDefinition pd = ((ColumnReference)sel).getPropertyDefinition();
                        boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
                        Object propVal1 = PropertyQueryUtil.getProperty(so1, propId, pd, cmis11);
                        Object propVal2 = PropertyQueryUtil.getProperty(so2, propId, pd, cmis11);
                        result = propVal1 == null && propVal2 == null ? 0 : (propVal1 == null ? -1 : (propVal2 == null ? 1 : ((Comparable)propVal1).compareTo(propVal2)));
                    } else {
                        result = 0;
                    }
                    if (!s.isAscending()) {
                        result = -result;
                    }
                    return result;
                }
            }
            Collections.sort(this.matches, new ResultComparator());
        }
    }

    private void match(StoredObject so, String user, boolean searchAllVersions) {
        String queryName = (String)this.queryObj.getTypes().values().iterator().next();
        TypeDefinition td = this.queryObj.getTypeDefinitionFromQueryName(queryName);
        boolean skip = so instanceof VersionedDocument;
        boolean typeMatches = this.typeMatches(td, so);
        if (!searchAllVersions && so instanceof DocumentVersion && ((DocumentVersion)so).getParentDocument().getLatestVersion(false) != so) {
            skip = true;
        }
        if (typeMatches && !skip) {
            this.evalWhereTree(this.whereTree, user, so);
        }
    }

    private void evalWhereTree(Tree node, String user, StoredObject so) {
        boolean match = true;
        if (null != node) {
            match = this.evalWhereNode(so, user, node);
        }
        if (match && this.objStore.hasReadAccess(user, so)) {
            this.matches.add(so);
        }
    }

    private boolean evalWhereNode(StoredObject so, String user, Tree node) {
        return new InMemoryWhereClauseWalker(so, user).walkPredicate(node);
    }

    private boolean hasParent(StoredObject objInFolder, String folderId, String user) {
        List<String> parents = this.objStore.getParentIds(objInFolder, user);
        for (String parentId : parents) {
            if (!folderId.equals(parentId)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAncestor(StoredObject objInFolder, String folderId, String user) {
        List<String> parents = this.objStore.getParentIds(objInFolder, user);
        for (String parentId : parents) {
            if (!folderId.equals(parentId)) continue;
            return true;
        }
        for (String parentId : parents) {
            Folder parentFolder = (Folder)this.objStore.getObjectById(parentId);
            if (!this.hasAncestor(parentFolder, folderId, user)) continue;
            return true;
        }
        return false;
    }

    protected int compareTo(PropertyDefinition<?> td, Object lValue, Object rVal) {
        switch (td.getPropertyType()) {
            case BOOLEAN: {
                if (rVal instanceof Boolean) {
                    return ((Boolean)lValue).compareTo((Boolean)rVal);
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case INTEGER: {
                Long lLongValue = ((BigInteger)lValue).longValue();
                if (rVal instanceof Long) {
                    return lLongValue.compareTo((Long)rVal);
                }
                if (rVal instanceof Double) {
                    return Double.valueOf(((Integer)lValue).doubleValue()).compareTo((Double)rVal);
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case DATETIME: {
                if (rVal instanceof GregorianCalendar) {
                    return ((GregorianCalendar)lValue).compareTo((GregorianCalendar)rVal);
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case DECIMAL: {
                Double lDoubleValue = ((BigDecimal)lValue).doubleValue();
                if (rVal instanceof Double) {
                    return lDoubleValue.compareTo((Double)rVal);
                }
                if (rVal instanceof Long) {
                    return lDoubleValue.compareTo((double)((Long)rVal));
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case HTML: 
            case URI: 
            case ID: {
                if (rVal instanceof String) {
                    LOG.debug("compare strings: " + lValue + " with " + rVal);
                    return ((String)lValue).compareTo((String)rVal);
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
                break;
            }
            case STRING: {
                if (rVal instanceof String) {
                    String unesc = StringUtil.unescape((String)((String)rVal), null);
                    LOG.debug("compare strings: " + lValue + " with " + unesc);
                    return ((String)lValue).compareTo(unesc);
                }
                InMemoryQueryProcessor.throwIncompatibleTypesException(lValue, rVal);
            }
        }
        return 0;
    }

    private ColumnReference getColumnReference(Tree columnNode) {
        CmisSelector sel = this.queryObj.getColumnReference(Integer.valueOf(columnNode.getTokenStartIndex()));
        if (null == sel) {
            throw new IllegalStateException("Unknown property query name " + columnNode.getChild(0));
        }
        if (sel instanceof ColumnReference) {
            return (ColumnReference)sel;
        }
        throw new IllegalStateException("Unexpected numerical value function in where clause");
    }

    private String getTableReference(Tree tableNode) {
        String typeQueryName = this.queryObj.getTypeQueryName(tableNode.getText());
        if (null == typeQueryName) {
            throw new IllegalStateException("Inavlid type in IN_FOLDER() or IN_TREE(), must be in FROM list: " + tableNode.getText());
        }
        return typeQueryName;
    }

    private void doAdditionalChecks(CmisQueryWalker walker) {
        if (walker.getNumberOfContainsClauses() > 1) {
            throw new CmisInvalidArgumentException("More than one CONTAINS clause is not allowed");
        }
        List joins = this.queryObj.getJoins();
        if (null == this.secondaryTypeIds && joins.size() > 0) {
            throw new CmisInvalidArgumentException("JOINs are not supported with the exception of secondary types");
        }
    }

    public static String translatePattern(String wildcardString) {
        int index = 0;
        int start = 0;
        String wildcard = wildcardString;
        StringBuilder res = new StringBuilder();
        while (index >= 0) {
            index = wildcard.indexOf(37, start);
            if (index < 0) {
                res.append(wildcard.substring(start));
            } else if (index == 0 || index > 0 && wildcard.charAt(index - 1) != '\\') {
                res.append(wildcard.substring(start, index));
                res.append(".*");
            } else {
                res.append(wildcard.substring(start, index + 1));
            }
            start = index + 1;
        }
        wildcard = res.toString();
        index = 0;
        start = 0;
        res = new StringBuilder();
        while (index >= 0) {
            index = wildcard.indexOf(95, start);
            if (index < 0) {
                res.append(wildcard.substring(start));
            } else if (index == 0 || index > 0 && wildcard.charAt(index - 1) != '\\') {
                res.append(wildcard.substring(start, index));
                res.append(".");
            } else {
                res.append(wildcard.substring(start, index + 1));
            }
            start = index + 1;
        }
        return res.toString();
    }

    private static void throwIncompatibleTypesException(Object o1, Object o2) {
        throw new CmisInvalidArgumentException("Incompatible Types to compare: " + o1 + " and " + o2);
    }

    public class InMemoryWhereClauseWalker
    extends AbstractPredicateWalker {
        protected final StoredObject so;
        protected final String user;

        public InMemoryWhereClauseWalker(StoredObject so, String user) {
            this.so = so;
            this.user = user;
        }

        public Boolean walkNot(Tree opNode, Tree node) {
            boolean hasMatched = this.walkPredicate(node);
            return !hasMatched;
        }

        public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
            boolean matches1 = this.walkPredicate(leftNode);
            boolean matches2 = this.walkPredicate(rightNode);
            return matches1 && matches2;
        }

        public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
            boolean matches1 = this.walkPredicate(leftNode);
            boolean matches2 = this.walkPredicate(rightNode);
            return matches1 || matches2;
        }

        public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp == 0;
        }

        public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp != 0;
        }

        public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp > 0;
        }

        public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp >= 0;
        }

        public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp < 0;
        }

        public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            Integer cmp = this.compareTo(leftNode, rightNode);
            return cmp == null ? false : cmp <= 0;
        }

        public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            List<Object> literals = this.onLiteralList(listNode);
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            Object prop = PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalStateException("Operator IN only is allowed on single-value properties ");
            }
            if (prop == null) {
                return false;
            }
            return literals.contains(prop);
        }

        public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            Object prop = PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalStateException("Operator IN only is allowed on single-value properties ");
            }
            if (prop == null) {
                return false;
            }
            return !literals.contains(prop);
        }

        public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new IllegalStateException("Operator ANY...IN only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            for (Object prop : props) {
                LOG.debug("comparing with: " + prop);
                if (!literals.contains(prop)) continue;
                return true;
            }
            return false;
        }

        public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            List<Object> literals = this.onLiteralList(listNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new IllegalStateException("Operator ANY...IN only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            for (Object prop : props) {
                LOG.debug("comparing with: " + prop);
                if (!literals.contains(prop)) continue;
                return false;
            }
            return true;
        }

        public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyData<?> lVal = this.so.getProperties().get(colRef.getPropertyId());
            Object literal = this.walkExpr(literalNode);
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new IllegalStateException("Operator = ANY only is allowed on multi-value properties ");
            }
            if (lVal == null) {
                return false;
            }
            List props = lVal.getValues();
            return props.contains(literal);
        }

        public Boolean walkIsNull(Tree opNode, Tree colNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            Object propVal = PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            return propVal == null;
        }

        public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            Object propVal = PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            return propVal != null;
        }

        public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
            Object rVal = this.walkExpr(stringNode);
            if (!(rVal instanceof String)) {
                throw new IllegalStateException("LIKE operator requires String literal on right hand side.");
            }
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(colNode);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            PropertyType propType = pd.getPropertyType();
            if (propType != PropertyType.STRING && propType != PropertyType.HTML && propType != PropertyType.ID && propType != PropertyType.URI) {
                throw new IllegalStateException("Property type " + propType.value() + " is not allowed FOR LIKE");
            }
            if (pd.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalStateException("LIKE is not allowed for multi-value properties ");
            }
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            String propVal = (String)PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            if (null == propVal) {
                return false;
            }
            String pattern = InMemoryQueryProcessor.translatePattern((String)rVal);
            Pattern p = Pattern.compile(pattern);
            return p.matcher(propVal).matches();
        }

        public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
            return this.walkLike(opNode, colNode, stringNode) == false;
        }

        public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
            Object lit;
            if (null != qualNode) {
                InMemoryQueryProcessor.this.getTableReference(qualNode);
            }
            if (!((lit = this.walkExpr(paramNode)) instanceof String)) {
                throw new IllegalStateException("Folder id in IN_FOLDER must be of type String");
            }
            String folderId = (String)lit;
            if (this.so instanceof Filing) {
                return InMemoryQueryProcessor.this.hasParent(this.so, folderId, this.user);
            }
            return false;
        }

        public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
            Object lit;
            if (null != qualNode) {
                InMemoryQueryProcessor.this.getTableReference(qualNode);
            }
            if (!((lit = this.walkExpr(paramNode)) instanceof String)) {
                throw new IllegalStateException("Folder id in IN_FOLDER must be of type String");
            }
            String folderId = (String)lit;
            if (this.so instanceof Filing) {
                return InMemoryQueryProcessor.this.hasAncestor(this.so, folderId, this.user);
            }
            return false;
        }

        protected Integer compareTo(Tree leftChild, Tree rightChild) {
            Object rVal = this.walkExpr(rightChild);
            ColumnReference colRef = InMemoryQueryProcessor.this.getColumnReference(leftChild);
            PropertyDefinition pd = colRef.getPropertyDefinition();
            boolean cmis11 = InMemoryQueryProcessor.this.callContext.getCmisVersion() != CmisVersion.CMIS_1_0;
            Object val = PropertyQueryUtil.getProperty(this.so, colRef.getPropertyId(), pd, cmis11);
            if (val == null) {
                return null;
            }
            if (val instanceof List) {
                throw new IllegalStateException("You can't query operators <, <=, ==, !=, >=, > on multi-value properties ");
            }
            return InMemoryQueryProcessor.this.compareTo(pd, val, rVal);
        }

        public List<Object> onLiteralList(Tree node) {
            return (List)this.walkExpr(node);
        }

        protected Boolean walkTextAnd(Tree node) {
            List<Tree> terms = this.getChildrenAsList(node);
            for (Tree term : terms) {
                Boolean foundOnce = this.walkSearchExpr(term);
                if (foundOnce != null && foundOnce.booleanValue()) continue;
                return false;
            }
            return true;
        }

        protected Boolean walkTextOr(Tree node) {
            List<Tree> terms = this.getChildrenAsList(node);
            for (Tree term : terms) {
                Boolean foundOnce = this.walkSearchExpr(term);
                if (foundOnce == null || !foundOnce.booleanValue()) continue;
                return true;
            }
            return false;
        }

        protected Boolean walkTextMinus(Tree node) {
            return !this.findText(node.getChild(0).getText());
        }

        protected Boolean walkTextWord(Tree node) {
            return this.findText(node.getText());
        }

        protected Boolean walkTextPhrase(Tree node) {
            String phrase = node.getText();
            return this.findText(phrase.substring(1, phrase.length() - 1));
        }

        private List<Tree> getChildrenAsList(Tree node) {
            ArrayList<Tree> res = new ArrayList<Tree>(node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                Tree childNnode = node.getChild(i);
                res.add(childNnode);
            }
            return res;
        }

        private boolean findText(String nodeText) {
            String pattern = StringUtil.unescape((String)nodeText, (String)"\\'-");
            if (null == pattern) {
                throw new CmisInvalidArgumentException("Illegal Escape sequence in text search expression " + nodeText);
            }
            if (this.so instanceof Content && ((Content)((Object)this.so)).hasContent()) {
                Content cont = (Content)((Object)this.so);
                ContentStreamDataImpl cdi = (ContentStreamDataImpl)cont.getContent();
                if (cdi.getMimeType().startsWith("text/")) {
                    String text;
                    byte[] ba = cdi.getBytes();
                    try {
                        text = new String(ba, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CmisRuntimeException("Internal error: Unsupported encoding UTF-8", (Throwable)e);
                    }
                    int match = text.indexOf(pattern);
                    return match >= 0;
                }
                return false;
            }
            return false;
        }
    }
}

