/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluPOSSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class ConlluPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample> {
    public static final String CONLLU_FORMAT = "conllu";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLU_FORMAT, new ConlluPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ConlluPOSSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        ConlluTagset tagset;
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        switch (params.getTagset()) {
            case "u": {
                tagset = ConlluTagset.U;
                break;
            }
            case "x": {
                tagset = ConlluTagset.X;
                break;
            }
            default: {
                throw new TerminateToolException(-1, "Unkown tagset parameter: " + params.getTagset());
            }
        }
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
        try {
            return new ConlluPOSSampleStream(new ConlluStream(inFactory), tagset);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="tagset", description="u|x u for unified tags and x for language-specific part-of-speech tags")
        @ArgumentParser.OptionalParameter(defaultValue="u")
        public String getTagset();
    }
}

