/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import java.net.URI;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyUtils {
    public static Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        return (Response)httpServletResponse;
    }

    public static URI getUri(Request request) {
        try {
            return JettyUtils.toUri(request.getClass().getDeclaredMethod("getUri", new Class[0]).invoke((Object)request, new Object[0]));
        }
        catch (Exception ignored) {
            try {
                return JettyUtils.toUri(request.getClass().getDeclaredMethod("getHttpURI", new Class[0]).invoke((Object)request, new Object[0]));
            }
            catch (Exception ignored2) {
                throw new IllegalArgumentException(request + " does not have a getUri or getHttpURI method");
            }
        }
    }

    private static URI toUri(Object httpURI) {
        return URI.create(httpURI.toString());
    }
}

