/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class NumberProperty
extends Property
implements Numeric {
    private static final PropertyCache cache = new PropertyCache(NumberProperty.class);
    private final Number number;

    private NumberProperty(double num) {
        this.number = num == Math.floor(num) ? (Number)(num < 2.147483647E9 ? (Number)new Integer((int)num) : (Number)new Long((long)num)) : (Number)new Double(num);
    }

    private NumberProperty(int num) {
        this.number = new Integer(num);
    }

    public static NumberProperty getInstance(Double num) {
        return (NumberProperty)cache.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(Integer num) {
        return (NumberProperty)cache.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(double num) {
        return (NumberProperty)cache.fetch(new NumberProperty(num));
    }

    public static NumberProperty getInstance(int num) {
        return (NumberProperty)cache.fetch(new NumberProperty(num));
    }

    public int getDimension() {
        return 0;
    }

    public double getNumericValue() {
        return this.number.doubleValue();
    }

    public double getNumericValue(PercentBaseContext context) {
        return this.getNumericValue();
    }

    public int getValue() {
        return this.number.intValue();
    }

    public int getValue(PercentBaseContext context) {
        return this.getValue();
    }

    public boolean isAbsolute() {
        return true;
    }

    public Number getNumber() {
        return this.number;
    }

    public Object getObject() {
        return this.number;
    }

    public Numeric getNumeric() {
        return this;
    }

    public Length getLength() {
        return FixedLength.getInstance(this.getNumericValue(), "px");
    }

    public Color getColor(FOUserAgent foUserAgent) {
        return Color.black;
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NumberProperty) {
            NumberProperty np = (NumberProperty)o;
            return np.number == this.number || this.number != null && this.number.equals(np.number);
        }
        return false;
    }

    public static class PositiveIntegerMaker
    extends PropertyMaker {
        public PositiveIntegerMaker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof EnumProperty) {
                return EnumNumber.getInstance(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                int i = Math.round(val.floatValue());
                if (i <= 0) {
                    i = 1;
                }
                return NumberProperty.getInstance(i);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof NumberProperty) {
                return p;
            }
            if (p instanceof EnumProperty) {
                return EnumNumber.getInstance(p);
            }
            Number val = p.getNumber();
            if (val != null) {
                return NumberProperty.getInstance(val.doubleValue());
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

