/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class EqualAreaProjection
extends NormalizedProjection {
    private static final long serialVersionUID = 2221537810038553082L;
    private static final double ECCENTRICITY_THRESHOLD = 0.1;
    private final double c2\u03b2;
    private final double c4\u03b2;
    private final double c6\u03b2;
    private final double qmPolar;
    private final boolean useIterations;

    EqualAreaProjection(Initializer initializer) {
        super(initializer);
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        this.c2\u03b2 = 0.5714285714285714 * d3 + 0.6 * d2 + 0.6666666666666666 * d;
        this.c4\u03b2 = -1.0680776014109348 * d3 + -0.5111111111111111 * d2;
        this.c6\u03b2 = 0.5368606701940035 * d3;
        this.qmPolar = this.qm(1.0);
        this.useIterations = this.eccentricity >= 0.1;
    }

    EqualAreaProjection(EqualAreaProjection equalAreaProjection) {
        super(equalAreaProjection);
        this.c2\u03b2 = equalAreaProjection.c2\u03b2;
        this.c4\u03b2 = equalAreaProjection.c4\u03b2;
        this.c6\u03b2 = equalAreaProjection.c6\u03b2;
        this.qmPolar = equalAreaProjection.qmPolar;
        this.useIterations = equalAreaProjection.useIterations;
    }

    final double qm(double d) {
        return this.eccentricity == 0.0 ? 2.0 * d : this.qm_ellipsoid(d);
    }

    final double qm_ellipsoid(double d) {
        double d2 = this.eccentricity * d;
        return d / (1.0 - d2 * d2) + MathFunctions.atanh(d2) / this.eccentricity;
    }

    final double dqm_d\u03c6(double d, double d2) {
        double d3 = 1.0 - this.eccentricitySquared * (d * d);
        return 2.0 * d2 / (d3 * d3);
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2;
        double d3 = d / this.qmPolar;
        double d4 = d3 * d3;
        double d5 = Math.asin(d3);
        double d6 = d5 + Math.cos(d5) * d3 * (this.c2\u03b2 + d4 * (this.c4\u03b2 + d4 * this.c6\u03b2));
        if (this.useIterations) {
            for (int i = 0; i < 18; ++i) {
                double d7 = Math.sin(d6);
                double d8 = Math.cos(d6);
                double d9 = this.eccentricity * d7;
                double d10 = 1.0 - d9 * d9;
                double d11 = d10 * d10 / (2.0 * d8) * (d - d7 / d10 - MathFunctions.atanh(d9) / this.eccentricity);
                d6 += d11;
                if (!(Math.abs(d11) <= 3.926676682852614E-10)) continue;
                return d6;
            }
        } else if (!Double.isNaN(d6)) {
            return d6;
        }
        if (Math.abs((d2 = Math.abs(d3)) - 1.0) < 1.5706706731410455E-9) {
            return Math.copySign(1.5707963267948966, d);
        }
        if (d2 >= 1.0 || Double.isNaN(d)) {
            return Double.NaN;
        }
        throw new ProjectionException(Resources.format((short)46));
    }
}

