/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisACLType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumACLPropagation;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedAclService;

public class AclServiceImpl
extends AbstractWebServicesService
implements AclService,
ExtendedAclService {
    private final AbstractPortProvider portProvider;

    public AclServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addACEs, Acl removeACEs, AclPropagation aclPropagation, ExtensionsData extension) {
        ACLServicePort port = this.portProvider.getACLServicePort(this.getCmisVersion(repositoryId), "applyACL");
        try {
            Acl acl = WSConverter.convert((CmisACLType)port.applyACL(repositoryId, objectId, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), (EnumACLPropagation)WSConverter.convert(EnumACLPropagation.class, (Enum)aclPropagation), WSConverter.convert((ExtensionsData)extension)));
            return acl;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        ACLServicePort port = this.portProvider.getACLServicePort(this.getCmisVersion(repositoryId), "getACL");
        try {
            Acl acl = WSConverter.convert((CmisACLType)port.getACL(repositoryId, objectId, onlyBasicPermissions, WSConverter.convert((ExtensionsData)extension)));
            return acl;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public Acl setAcl(String repositoryId, String objectId, Acl aces) {
        Acl currentAcl = this.getAcl(repositoryId, objectId, false, null);
        ArrayList<Ace> removeAces = new ArrayList<Ace>();
        if (currentAcl.getAces() != null) {
            for (Ace ace : currentAcl.getAces()) {
                if (!ace.isDirect()) continue;
                removeAces.add(ace);
            }
        }
        return this.applyAcl(repositoryId, objectId, aces, (Acl)new AccessControlListImpl(removeAces), AclPropagation.OBJECTONLY, null);
    }
}

