/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.noggit.CharArr;
import org.noggit.JSONUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWriter {
    protected int level;
    protected int indent;
    protected final CharArr out;

    public JSONWriter(CharArr out, int indentSize) {
        this.out = out;
        this.indent = indentSize;
    }

    public JSONWriter(CharArr out) {
        this(out, 2);
    }

    public void setIndentSize(int indentSize) {
        this.indent = indentSize;
    }

    public void indent() {
        if (this.indent >= 0) {
            this.out.write('\n');
            if (this.indent > 0) {
                int spaces = this.level * this.indent;
                this.out.reserve(spaces);
                for (int i = 0; i < spaces; ++i) {
                    this.out.unsafeWrite(' ');
                }
            }
        }
    }

    public void write(Object o) {
        if (o == null) {
            this.writeNull();
        } else if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Long) {
                this.write(((Number)o).longValue());
            } else if (o instanceof Float || o instanceof Double) {
                this.write(((Number)o).doubleValue());
            } else {
                CharArr arr = new CharArr();
                arr.write(o.toString());
                this.writeNumber(arr);
            }
        } else if (o instanceof Map) {
            this.write((Map)o);
        } else if (o instanceof Collection) {
            this.write((Collection)o);
        } else if (o instanceof Boolean) {
            this.write((Boolean)o);
        } else if (o instanceof CharSequence) {
            this.writeString((CharSequence)o);
        } else if (o instanceof Writable) {
            ((Writable)o).write(this);
        } else if (o instanceof Object[]) {
            this.write(Arrays.asList((Object[])o));
        } else if (o instanceof int[]) {
            this.write((int[])o);
        } else if (o instanceof float[]) {
            this.write((float[])o);
        } else if (o instanceof long[]) {
            this.write((long[])o);
        } else if (o instanceof double[]) {
            this.write((double[])o);
        } else if (o instanceof short[]) {
            this.write((short[])o);
        } else if (o instanceof boolean[]) {
            this.write((boolean[])o);
        } else if (o instanceof char[]) {
            this.write((char[])o);
        } else if (o instanceof byte[]) {
            this.write((byte[])o);
        } else {
            this.handleUnknownClass(o);
        }
    }

    public void handleUnknownClass(Object o) {
        this.writeString(o.toString());
    }

    public void write(Map<?, ?> val) {
        this.startObject();
        int sz = val.size();
        boolean first = true;
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            if (sz > 1) {
                this.indent();
            }
            this.writeString(entry.getKey().toString());
            this.writeNameSeparator();
            this.write(entry.getValue());
        }
        this.endObject();
    }

    public void write(Collection<?> val) {
        this.startArray();
        int sz = val.size();
        boolean first = true;
        for (Object o : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            if (sz > 1) {
                this.indent();
            }
            this.write(o);
        }
        this.endArray();
    }

    public void write(byte[] val) {
        this.startArray();
        boolean first = true;
        byte[] arr$ = val;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short v = arr$[i$];
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(short[] val) {
        this.startArray();
        boolean first = true;
        for (short v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(int[] val) {
        this.startArray();
        boolean first = true;
        for (int v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(long[] val) {
        this.startArray();
        boolean first = true;
        for (long v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(float[] val) {
        this.startArray();
        boolean first = true;
        for (float v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(double[] val) {
        this.startArray();
        boolean first = true;
        for (double v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(boolean[] val) {
        this.startArray();
        boolean first = true;
        for (boolean v : val) {
            if (first) {
                first = false;
            } else {
                this.writeValueSeparator();
            }
            this.write(v);
        }
        this.endArray();
    }

    public void write(short number) {
        this.write((int)number);
    }

    public void write(byte number) {
        this.write((int)number);
    }

    public void writeNull() {
        JSONUtil.writeNull(this.out);
    }

    public void writeString(String str) {
        JSONUtil.writeString(str, 0, str.length(), this.out);
    }

    public void writeString(CharSequence str) {
        JSONUtil.writeString(str, 0, str.length(), this.out);
    }

    public void writeString(CharArr str) {
        JSONUtil.writeString(str, this.out);
    }

    public void writeStringStart() {
        this.out.write('\"');
    }

    public void writeStringChars(CharArr partialStr) {
        JSONUtil.writeStringPart(partialStr.getArray(), partialStr.getStart(), partialStr.getEnd(), this.out);
    }

    public void writeStringEnd() {
        this.out.write('\"');
    }

    public void write(long number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(int number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(double number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(float number) {
        JSONUtil.writeNumber(number, this.out);
    }

    public void write(boolean bool) {
        JSONUtil.writeBoolean(bool, this.out);
    }

    public void write(char[] val) {
        JSONUtil.writeString(val, 0, val.length, this.out);
    }

    public void writeNumber(CharArr digits) {
        this.out.write(digits);
    }

    public void writePartialNumber(CharArr digits) {
        this.out.write(digits);
    }

    public void startObject() {
        this.out.write('{');
        ++this.level;
    }

    public void endObject() {
        this.out.write('}');
        --this.level;
    }

    public void startArray() {
        this.out.write('[');
        ++this.level;
    }

    public void endArray() {
        this.out.write(']');
        --this.level;
    }

    public void writeValueSeparator() {
        this.out.write(',');
    }

    public void writeNameSeparator() {
        this.out.write(':');
    }

    public static interface Writable {
        public void write(JSONWriter var1);
    }
}

