/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;

public class FileCodestreamWriter
extends CodestreamWriter
implements Markers {
    private static final int SOP_MARKER_LIMIT = 65535;
    private int tileIdx = 0;
    private OutputStream out;
    int ndata = 0;
    public static int DEF_BUF_LEN = 1024;
    byte[] sopMarker;
    byte[] ephMarker;
    int packetIdx = 0;
    private int offLastROIPkt = 0;
    private int lenLastNoROI = 0;

    public FileCodestreamWriter(File file, int mb) throws IOException {
        super(mb);
        this.out = new BufferedOutputStream(new FileOutputStream(file), DEF_BUF_LEN);
        this.initSOP_EPHArrays();
    }

    public FileCodestreamWriter(String fname, int mb) throws IOException {
        super(mb);
        this.out = new BufferedOutputStream(new FileOutputStream(fname), DEF_BUF_LEN);
        this.initSOP_EPHArrays();
    }

    public FileCodestreamWriter(OutputStream os, int mb) throws IOException {
        super(mb);
        this.out = os;
        this.initSOP_EPHArrays();
    }

    @Override
    public final int getMaxAvailableBytes() {
        return this.maxBytes - this.ndata;
    }

    @Override
    public int getLength() {
        if (this.getMaxAvailableBytes() >= 0) {
            return this.ndata;
        }
        return this.maxBytes;
    }

    @Override
    public int writePacketHead(byte[] head, int hlen, boolean sim, boolean sop, boolean eph) throws IOException {
        int len = hlen + (sop ? 6 : 0) + (eph ? 2 : 0);
        if (!sim) {
            if (this.getMaxAvailableBytes() < len) {
                len = this.getMaxAvailableBytes();
            }
            if (len > 0) {
                if (sop) {
                    this.sopMarker[4] = (byte)(this.packetIdx >> 8);
                    this.sopMarker[5] = (byte)this.packetIdx;
                    this.out.write(this.sopMarker, 0, 6);
                    ++this.packetIdx;
                    if (this.packetIdx > 65535) {
                        this.packetIdx = 0;
                    }
                }
                this.out.write(head, 0, hlen);
                this.ndata += len;
                if (eph) {
                    this.out.write(this.ephMarker, 0, 2);
                }
                this.lenLastNoROI += len;
            }
        }
        return len;
    }

    @Override
    public int writePacketBody(byte[] body, int blen, boolean sim, boolean roiInPkt, int roiLen) throws IOException {
        int len = blen;
        if (!sim) {
            len = blen;
            if (this.getMaxAvailableBytes() < len) {
                len = this.getMaxAvailableBytes();
            }
            if (blen > 0) {
                this.out.write(body, 0, len);
            }
            this.ndata += len;
            if (roiInPkt) {
                this.offLastROIPkt += this.lenLastNoROI + roiLen;
                this.lenLastNoROI = len - roiLen;
            } else {
                this.lenLastNoROI += len;
            }
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.out.write(-1);
        this.out.write(-39);
        this.ndata += 2;
        this.out.close();
    }

    @Override
    public int getOffLastROIPkt() {
        return this.offLastROIPkt;
    }

    @Override
    public void commitBitstreamHeader(HeaderEncoder he) throws IOException {
        this.ndata += he.getLength();
        he.writeTo(this.out);
        this.packetIdx = 0;
        this.lenLastNoROI += he.getLength();
    }

    private void initSOP_EPHArrays() {
        this.sopMarker = new byte[6];
        this.sopMarker[0] = -1;
        this.sopMarker[1] = -111;
        this.sopMarker[2] = 0;
        this.sopMarker[3] = 4;
        this.ephMarker = new byte[2];
        this.ephMarker[0] = -1;
        this.ephMarker[1] = -110;
    }
}

