/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.jira;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.jira.JiraSession;
import org.apache.manifoldcf.authorities.authorities.jira.Messages;
import org.apache.manifoldcf.authorities.authorities.jira.ResponseException;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class JiraAuthorityConnector
extends BaseAuthorityConnector {
    private static final String JIRA_SERVER_TAB_PROPERTY = "JiraAuthorityConnector.Server";
    private static final String JIRA_PROXY_TAB_PROPERTY = "JiraAuthorityConnector.Proxy";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_jira.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_jira_server.html";
    private static final String EDIT_CONFIG_FORWARD_PROXY = "editConfiguration_jira_proxy.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_jira.html";
    protected JiraSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected String jiraprotocol = null;
    protected String jirahost = null;
    protected String jiraport = null;
    protected String jirapath = null;
    protected String clientid = null;
    protected String clientsecret = null;
    protected String jiraproxyhost = null;
    protected String jiraproxyport = null;
    protected String jiraproxydomain = null;
    protected String jiraproxyusername = null;
    protected String jiraproxypassword = null;

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
        this.jiraprotocol = null;
        this.jirahost = null;
        this.jiraport = null;
        this.jirapath = null;
        this.clientid = null;
        this.clientsecret = null;
        this.jiraproxyhost = null;
        this.jiraproxyport = null;
        this.jiraproxydomain = null;
        this.jiraproxyusername = null;
        this.jiraproxypassword = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.jiraprotocol = this.params.getParameter("jiraprotocol");
        this.jirahost = this.params.getParameter("jirahost");
        this.jiraport = this.params.getParameter("jiraport");
        this.jirapath = this.params.getParameter("jirapath");
        this.clientid = this.params.getParameter("clientid");
        this.clientsecret = this.params.getObfuscatedParameter("clientsecret");
        this.jiraproxyhost = this.params.getParameter("jiraproxyhost");
        this.jiraproxyport = this.params.getParameter("jiraproxyport");
        this.jiraproxydomain = this.params.getParameter("jiraproxydomain");
        this.jiraproxyusername = this.params.getParameter("jiraproxyusername");
        this.jiraproxypassword = this.params.getObfuscatedParameter("jiraproxypassword");
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected JiraSession getSession() throws ManifoldCFException {
        if (this.session == null) {
            int proxyPortInt;
            int portInt;
            if (StringUtils.isEmpty((String)this.jiraprotocol)) {
                throw new ManifoldCFException("Parameter jiraprotocol required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: jiraprotocol = '" + this.jiraprotocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.jirahost)) {
                throw new ManifoldCFException("Parameter jirahost required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: jirahost = '" + this.jirahost + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: jiraport = '" + this.jiraport + "'"));
            }
            if (StringUtils.isEmpty((String)this.jirapath)) {
                throw new ManifoldCFException("Parameter jirapath required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: jirapath = '" + this.jirapath + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: Clientid = '" + this.clientid + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("JIRA: Clientsecret = '" + this.clientsecret + "'"));
            }
            if (this.jiraport != null && this.jiraport.length() > 0) {
                try {
                    portInt = Integer.parseInt(this.jiraport);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                portInt = this.jiraprotocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
            }
            if (this.jiraproxyport != null && this.jiraproxyport.length() > 0) {
                try {
                    proxyPortInt = Integer.parseInt(this.jiraproxyport);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                proxyPortInt = 8080;
            }
            this.session = new JiraSession(this.clientid, this.clientsecret, this.jiraprotocol, this.jirahost, portInt, this.jirapath, this.jiraproxyhost, proxyPortInt, this.jiraproxydomain, this.jiraproxyusername, this.jiraproxypassword);
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.session;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String jiraprotocol = parameters.getParameter("jiraprotocol");
        String jirahost = parameters.getParameter("jirahost");
        String jiraport = parameters.getParameter("jiraport");
        String jirapath = parameters.getParameter("jirapath");
        String clientid = parameters.getParameter("clientid");
        String clientsecret = parameters.getObfuscatedParameter("clientsecret");
        if (jiraprotocol == null) {
            jiraprotocol = "http";
        }
        if (jirahost == null) {
            jirahost = "";
        }
        if (jiraport == null) {
            jiraport = "";
        }
        if (jirapath == null) {
            jirapath = "/rest/api/2/";
        }
        if (clientid == null) {
            clientid = "";
        }
        clientsecret = clientsecret == null ? "" : mapper.mapPasswordToKey(clientsecret);
        newMap.put("JIRAPROTOCOL", jiraprotocol);
        newMap.put("JIRAHOST", jirahost);
        newMap.put("JIRAPORT", jiraport);
        newMap.put("JIRAPATH", jirapath);
        newMap.put("CLIENTID", clientid);
        newMap.put("CLIENTSECRET", clientsecret);
    }

    private static void fillInProxyConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String jiraproxyhost = parameters.getParameter("jiraproxyhost");
        String jiraproxyport = parameters.getParameter("jiraproxyport");
        String jiraproxydomain = parameters.getParameter("jiraproxydomain");
        String jiraproxyusername = parameters.getParameter("jiraproxyusername");
        String jiraproxypassword = parameters.getObfuscatedParameter("jiraproxypassword");
        if (jiraproxyhost == null) {
            jiraproxyhost = "";
        }
        if (jiraproxyport == null) {
            jiraproxyport = "";
        }
        if (jiraproxydomain == null) {
            jiraproxydomain = "";
        }
        if (jiraproxyusername == null) {
            jiraproxyusername = "";
        }
        jiraproxypassword = jiraproxypassword == null ? "" : mapper.mapPasswordToKey(jiraproxypassword);
        newMap.put("JIRAPROXYHOST", jiraproxyhost);
        newMap.put("JIRAPROXYPORT", jiraproxyport);
        newMap.put("JIRAPROXYDOMAIN", jiraproxydomain);
        newMap.put("JIRAPROXYUSERNAME", jiraproxyusername);
        newMap.put("JIRAPROXYPASSWORD", jiraproxypassword);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JiraAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraAuthorityConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, JIRA_SERVER_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, JIRA_PROXY_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JiraAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraAuthorityConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        JiraAuthorityConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraAuthorityConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_PROXY, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String jiraproxypassword;
        String jiraproxyusername;
        String jiraproxydomain;
        String jiraproxyport;
        String jiraproxyhost;
        String clientsecret;
        String clientid;
        String jirapath;
        String jiraport;
        String jirahost;
        String jiraprotocol = variableContext.getParameter("jiraprotocol");
        if (jiraprotocol != null) {
            parameters.setParameter("jiraprotocol", jiraprotocol);
        }
        if ((jirahost = variableContext.getParameter("jirahost")) != null) {
            parameters.setParameter("jirahost", jirahost);
        }
        if ((jiraport = variableContext.getParameter("jiraport")) != null) {
            parameters.setParameter("jiraport", jiraport);
        }
        if ((jirapath = variableContext.getParameter("jirapath")) != null) {
            parameters.setParameter("jirapath", jirapath);
        }
        if ((clientid = variableContext.getParameter("clientid")) != null) {
            parameters.setParameter("clientid", clientid);
        }
        if ((clientsecret = variableContext.getParameter("clientsecret")) != null) {
            parameters.setObfuscatedParameter("clientsecret", variableContext.mapKeyToPassword(clientsecret));
        }
        if ((jiraproxyhost = variableContext.getParameter("jiraproxyhost")) != null) {
            parameters.setParameter("jiraproxyhost", jiraproxyhost);
        }
        if ((jiraproxyport = variableContext.getParameter("jiraproxyport")) != null) {
            parameters.setParameter("jiraproxyport", jiraproxyport);
        }
        if ((jiraproxydomain = variableContext.getParameter("jiraproxydomain")) != null) {
            parameters.setParameter("jiraproxydomain", jiraproxydomain);
        }
        if ((jiraproxyusername = variableContext.getParameter("jiraproxyusername")) != null) {
            parameters.setParameter("jiraproxyusername", jiraproxyusername);
        }
        if ((jiraproxypassword = variableContext.getParameter("jiraproxypassword")) != null) {
            parameters.setObfuscatedParameter("jiraproxypassword", variableContext.mapKeyToPassword(jiraproxypassword));
        }
        return null;
    }

    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        if (this.checkUserExists(userName)) {
            return new AuthorizationResponse(new String[]{userName}, 0);
        }
        return RESPONSE_USERNOTFOUND;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.authorityConnectors.warn((Object)("JIRA: IO exception: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
    }

    private static void handleResponseException(ResponseException e) throws ManifoldCFException {
        throw new ManifoldCFException("Response exception: " + e.getMessage(), (Throwable)e);
    }

    protected boolean checkUserExists(String userName) throws ManifoldCFException {
        CheckUserExistsThread t = new CheckUserExistsThread(this.getSession(), userName);
        try {
            t.start();
            t.finishUp();
            return t.getResult();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraAuthorityConnector.handleResponseException(e);
        }
        return false;
    }

    protected void checkConnection() throws ManifoldCFException {
        CheckConnectionThread t = new CheckConnectionThread(this.getSession());
        try {
            t.start();
            t.finishUp();
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraAuthorityConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraAuthorityConnector.handleResponseException(e);
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final JiraSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(JiraSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class CheckUserExistsThread
    extends Thread {
        protected final JiraSession session;
        protected final String userName;
        protected Throwable exception = null;
        protected boolean result = false;

        public CheckUserExistsThread(JiraSession session, String userName) {
            this.session = session;
            this.userName = userName;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.result = this.session.checkUserExists(this.userName);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

