/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean isCombiningChar(char ch) {
        return false;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isNCName(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char[] chars = str.toCharArray();
        char ch = chars[0];
        if (!ValidationUtils.isLetter(ch) && ch != '_') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (ValidationUtils.isNCNameChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameChar(char ch) {
        if (ValidationUtils.isLetter(ch) || ValidationUtils.isDigit(ch)) {
            return true;
        }
        if (ValidationUtils.isExtender(ch) || ValidationUtils.isCombiningChar(ch)) {
            return true;
        }
        switch (ch) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNMToken(String str) {
        if (str == null) {
            return false;
        }
        char[] chars = str.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ValidationUtils.isLetter(ch) || ValidationUtils.isDigit(ch) || ValidationUtils.isExtender(ch) || ValidationUtils.isCombiningChar(ch)) continue;
            switch (ch) {
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCDATA(String str) {
        if (str == null) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isExtender(char ch) {
        if (ch >= '\u3031' && ch <= '\u3035') {
            return true;
        }
        if (ch >= '\u30fc' && ch <= '\u30fe') {
            return true;
        }
        switch (ch) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u309d': 
            case '\u309e': {
                return true;
            }
        }
        return false;
    }

    public static boolean isQName(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char[] chars = str.toCharArray();
        char ch = chars[0];
        if (!ValidationUtils.isLetter(ch) && ch != '_') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == ':' || ValidationUtils.isNCNameChar(chars[i])) continue;
            return false;
        }
        return true;
    }
}

