/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.csv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.csv.CSVUtils;
import org.apache.manifoldcf.crawler.connectors.csv.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;

public class CSVConnector
extends BaseRepositoryConnector {
    private static final Logger LOGGER = LogManager.getLogger((String)CSVConnector.class.getName());
    private static Level DOCPROCESSLEVEL = Level.forName((String)"DOCPROCESS", (int)450);
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_CSV_HTML = "editSpecification_CSV.html";
    private static final String VIEW_SPECIFICATION_CSV_HTML = "viewSpecification_CSV.html";
    protected static final String ACTIVITY_READ = "read";
    private static final String DOCUMENT_ID_SEPARATOR = ";;";

    public int getMaxDocumentRequest() {
        return 20;
    }

    public int getConnectorModel() {
        return 3;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{"CSV"};
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
    }

    public String check() throws ManifoldCFException {
        return super.check();
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : Long.parseLong(lastSeedVersion);
        CSVSpecs csvSpecs = new CSVSpecs(spec);
        Map<String, String[]> csvMap = csvSpecs.getCSVMap();
        for (String csvPath : csvMap.keySet()) {
            try {
                long numberOfLines = CSVUtils.getCSVLinesNumber(csvPath);
                for (long i = 1L; i < numberOfLines; ++i) {
                    String documentId = this.getDocumentIdentifier(i, csvPath);
                    activities.addSeedDocument(documentId);
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("Could not read CSV file " + csvPath + " : " + e.getMessage(), (Throwable)e);
            }
        }
        return String.valueOf(seedTime);
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        activities.checkJobStillActive();
        CSVSpecs csvSpecs = new CSVSpecs(spec);
        long startFetchTime = System.currentTimeMillis();
        HashMap<String, List<Long>> linesToReadPerDoc = new HashMap<String, List<Long>>();
        for (String documentIdentifier : documentIdentifiers) {
            LOGGER.log(DOCPROCESSLEVEL, "DOC_PROCESS_START|CSV|" + (String)documentIdentifier);
            String[] documentIdentifierArr = documentIdentifier.split(DOCUMENT_ID_SEPARATOR);
            String lineToRead = documentIdentifierArr[0];
            String docPath = documentIdentifierArr[1];
            if (linesToReadPerDoc.containsKey(docPath)) {
                ((List)linesToReadPerDoc.get(docPath)).add(Long.parseLong(lineToRead));
                continue;
            }
            ArrayList<Long> linesToRead = new ArrayList<Long>();
            linesToRead.add(Long.parseLong(lineToRead));
            linesToReadPerDoc.put(docPath, linesToRead);
        }
        for (String docPath : linesToReadPerDoc.keySet()) {
            String[] docLabels = csvSpecs.CSVMap.get(docPath);
            if (docLabels == null) {
                for (Long lineToRead : (List)linesToReadPerDoc.get(docPath)) {
                    String documentIdentifier = this.getDocumentIdentifier(lineToRead, docPath);
                    activities.deleteDocument(documentIdentifier);
                }
                continue;
            }
            try {
                this.processToIngestDocument(csvSpecs, docPath, linesToReadPerDoc, activities, startFetchTime);
            }
            catch (IOException e) {
                String errorCode = "KO";
                String description = "Unable to read file " + docPath + " : " + e.getMessage();
                String documentIdentifier = this.getDocumentIdentifier((Long)((List)linesToReadPerDoc.get(docPath)).get(0), docPath);
                activities.recordActivity(Long.valueOf(startFetchTime), ACTIVITY_READ, Long.valueOf(0L), documentIdentifier, errorCode, description, null);
                LOGGER.error(description, (Throwable)e);
            }
        }
    }

    private String getDocumentIdentifier(long lineToRead, String docPath) {
        return lineToRead + DOCUMENT_ID_SEPARATOR + docPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToIngestDocument(CSVSpecs csvSpecs, String docPath, Map<String, List<Long>> linesToReadPerDoc, IProcessActivity activities, long startFetchTime) throws ManifoldCFException, IOException, ServiceInterruption {
        String[] docLabels = csvSpecs.CSVMap.get(docPath);
        Object[] linesToRead = linesToReadPerDoc.get(docPath).toArray(new Long[0]);
        Arrays.sort(linesToRead);
        File csvFile = new File(docPath);
        long cptLine = 0L;
        int cptLinesToRead = 0;
        String versionString = "";
        long lineToRead = (Long)linesToRead[0];
        try (FileReader fr = new FileReader(csvFile);
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (cptLine < lineToRead) {
                    ++cptLine;
                    continue;
                }
                String documentIdentifier = this.getDocumentIdentifier(lineToRead, docPath);
                String ingestId = String.valueOf(lineToRead);
                RepositoryDocument rd = new RepositoryDocument();
                byte[] contentBytes = null;
                String[] values = line.split(csvSpecs.getSeparator());
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    String label = docLabels[i];
                    if (label.contentEquals(csvSpecs.getContentColumnLabel())) {
                        contentBytes = value.getBytes();
                        continue;
                    }
                    if (label.contentEquals(csvSpecs.getIdColumnLabel())) {
                        ingestId = value;
                    }
                    rd.addField(label, value);
                }
                if ("".length() == 0 || activities.checkDocumentNeedsReindexing(documentIdentifier, "")) {
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(contentBytes);){
                        rd.setBinary((InputStream)inputStream, (long)contentBytes.length);
                        activities.ingestDocumentWithException(documentIdentifier, "", ingestId, rd);
                        String errorCode = "OK";
                        activities.recordActivity(Long.valueOf(startFetchTime), ACTIVITY_READ, Long.valueOf(contentBytes.length), documentIdentifier, errorCode, "", null);
                    }
                    finally {
                        LOGGER.log(DOCPROCESSLEVEL, "DOC_PROCESS_END|CSV|" + documentIdentifier);
                    }
                }
                if (++cptLinesToRead < linesToRead.length) {
                    lineToRead = (Long)linesToRead[cptLinesToRead];
                    ++cptLine;
                    continue;
                }
                break;
            }
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "filepath_count");
        if (x != null && x.length() > 0) {
            i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("filepath")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String suffix;
                String prefix = seqPrefix + "filepath_";
                String op = variableContext.getParameter(prefix + "op" + (suffix = "_" + Integer.toString(i)));
                if (op != null && op.equals("Delete")) continue;
                String value = variableContext.getParameter(prefix + "value" + suffix);
                SpecificationNode node = new SpecificationNode("filepath");
                node.setAttribute("value", value);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter(seqPrefix + "filepath_op");
            if (addop != null && addop.equals("Add")) {
                String regex = variableContext.getParameter(seqPrefix + "filepath_value");
                SpecificationNode node = new SpecificationNode("filepath");
                node.setAttribute("value", regex);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "idcolumn")) != null) {
            i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("idcolumn")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (x.length() > 0) {
                SpecificationNode node = new SpecificationNode("idcolumn");
                node.setAttribute("value", x);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "contentcolumn")) != null) {
            i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("contentcolumn")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (x.length() > 0) {
                SpecificationNode node = new SpecificationNode("contentcolumn");
                node.setAttribute("value", x);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "separator")) != null) {
            i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("separator")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (x.length() > 0) {
                SpecificationNode node = new SpecificationNode("separator");
                node.setAttribute("value", x);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "CSV.CSVTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        this.fillInCSVSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_CSV_HTML, paramMap);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        this.fillInCSVSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_CSV_HTML, paramMap);
    }

    private void fillInCSVSpecificationMap(Map<String, Object> paramMap, Specification os) {
        ArrayList<String> filePaths = new ArrayList<String>();
        String contentColumn = "content";
        String idColumn = "id";
        String separator = ",";
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("filepath")) {
                String includeFileFilter = sn.getAttributeValue("value");
                if (includeFileFilter == null) continue;
                filePaths.add(includeFileFilter);
                continue;
            }
            if (sn.getType().equals("idcolumn")) {
                if (sn.getAttributeValue("value") == null) continue;
                idColumn = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("contentcolumn")) {
                if (sn.getAttributeValue("value") == null) continue;
                contentColumn = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("separator") || sn.getAttributeValue("value") == null) continue;
            separator = sn.getAttributeValue("value");
        }
        paramMap.put("FILEPATHS", filePaths);
        paramMap.put("CONTENTCOLUMN", contentColumn);
        paramMap.put("IDCOLUMN", idColumn);
        paramMap.put("SEPARATOR", separator);
    }

    private static class CSVSpecs {
        private final Map<String, String[]> CSVMap = new HashMap<String, String[]>();
        private String contentColumnLabel = "content";
        private final String idColumnLabel = "id";
        private String separator;

        public CSVSpecs(Specification os) {
            ArrayList<String> csvFiles = new ArrayList<String>();
            for (int i = 0; i < os.getChildCount(); ++i) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("filepath")) {
                    String value = sn.getAttributeValue("value");
                    csvFiles.add(value);
                    continue;
                }
                if (sn.getType().equals("contentcolumn")) {
                    this.contentColumnLabel = sn.getAttributeValue("value");
                    continue;
                }
                if (sn.getType().equals("separator")) {
                    this.separator = sn.getAttributeValue("value");
                    continue;
                }
                if (!sn.getType().equals("idcolumn")) continue;
                this.separator = sn.getAttributeValue("value");
            }
            for (String csvFilePath : csvFiles) {
                try {
                    String[] columnsLabel = CSVUtils.getColumnsLabel(csvFilePath, this.separator);
                    this.CSVMap.put(csvFilePath, columnsLabel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public Map<String, String[]> getCSVMap() {
            return this.CSVMap;
        }

        public String getContentColumnLabel() {
            return this.contentColumnLabel;
        }

        public String getIdColumnLabel() {
            return "id";
        }

        public String getSeparator() {
            return this.separator;
        }
    }
}

