/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import icc.lut.LookUpTable32;
import icc.tags.ICCCurveType;

public class LookUpTable32Interp
extends LookUpTable32 {
    public LookUpTable32Interp(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        super(curve, dwNumInput, dwMaxOutput);
        double dfRatio = (double)(curve.count - 1) / (double)(dwNumInput - 1);
        for (int i = 0; i < dwNumInput; ++i) {
            double dfOut;
            double dfHighIndex;
            int dwHighIndex;
            double dfTargetIndex = (double)i * dfRatio;
            double dfLowIndex = Math.floor(dfTargetIndex);
            int dwLowIndex = (int)dfLowIndex;
            if (dwLowIndex == (dwHighIndex = (int)(dfHighIndex = Math.ceil(dfTargetIndex)))) {
                dfOut = ICCCurveType.CurveToDouble(curve.entry(dwLowIndex));
            } else {
                double dfLow = ICCCurveType.CurveToDouble(curve.entry(dwLowIndex));
                double dfHigh = ICCCurveType.CurveToDouble(curve.entry(dwHighIndex));
                dfOut = dfLow + (dfHigh - dfLow) * (dfTargetIndex - dfLowIndex);
            }
            this.lut[i] = (int)Math.floor(dfOut * (double)dwMaxOutput + 0.5);
        }
    }
}

