/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RegressionEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public RegressionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(first instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        if (!(second instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        List l1 = (List)first;
        List l2 = (List)second;
        if (l2.size() < l1.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - first list (%d) has more values than the second list (%d)", this.toExpression(this.constructingFactory), l1.size(), l2.size()));
        }
        SimpleRegression regression = new SimpleRegression();
        for (int idx = 0; idx < l1.size(); ++idx) {
            regression.addData(((Number)l1.get(idx)).doubleValue(), ((Number)l2.get(idx)).doubleValue());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("slope", regression.getSlope());
        map.put("intercept", regression.getIntercept());
        map.put("R", regression.getR());
        map.put("N", regression.getN());
        map.put("RSquared", regression.getRSquare());
        map.put("regressionSumSquares", regression.getRegressionSumSquares());
        map.put("slopeConfidenceInterval", regression.getSlopeConfidenceInterval());
        map.put("interceptStdErr", regression.getInterceptStdErr());
        map.put("totalSumSquares", regression.getTotalSumSquares());
        map.put("significance", regression.getSignificance());
        map.put("meanSquareError", regression.getMeanSquareError());
        return new RegressionTuple(regression, map);
    }

    public static class RegressionTuple
    extends Tuple {
        private SimpleRegression simpleRegression;

        public RegressionTuple(SimpleRegression simpleRegression, Map<String, Object> map) {
            super(map);
            this.simpleRegression = simpleRegression;
        }

        public double predict(double value) {
            return this.simpleRegression.predict(value);
        }
    }
}

