/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;

public class DeepRandomStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected ModifiableSolrParams params;
    protected Map<String, String> fieldMappings;
    protected StreamComparator comp;
    private boolean trace;
    protected transient Map<String, Tuple> eofTuples;
    protected transient CloudSolrClient cloudSolrClient;
    protected transient List<TupleStream> solrStreams;
    protected transient LinkedList<TupleWrapper> tuples;
    protected transient StreamContext streamContext;

    public DeepRandomStream() {
    }

    public DeepRandomStream(String zkHost, String collectionName, SolrParams params) throws IOException {
        this.init(collectionName, zkHost, params);
    }

    public DeepRandomStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter aliasExpression = factory.getNamedOperand(expression, "aliases");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (null != aliasExpression && aliasExpression.getParameter() instanceof StreamExpressionValue) {
            this.fieldMappings = new HashMap<String, String>();
            for (String mapping : ((StreamExpressionValue)aliasExpression.getParameter()).getValue().split(",")) {
                String[] parts = mapping.trim().split("=");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - alias expected of the format origName=newName", expression));
                }
                this.fieldMappings.put(parts[0], parts[1]);
            }
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        this.init(collectionName, zkHost, mParams);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression("random");
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        for (Map.Entry<String, String[]> param : this.params.getMap().entrySet()) {
            for (String val : param.getValue()) {
                expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), val.replace("\"", "\\\"")));
            }
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        if (null != this.fieldMappings && 0 != this.fieldMappings.size()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> mapping : this.fieldMappings.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(mapping.getKey());
                sb.append("=");
                sb.append(mapping.getValue());
            }
            expression.addParameter(new StreamExpressionNamedParameter("aliases", sb.toString()));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName("random");
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (null != this.params) {
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    void init(String collectionName, String zkHost, SolrParams params) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.params = new ModifiableSolrParams(params);
        if (params.get("q") == null) {
            throw new IOException("q param expected for search function");
        }
        if (params.getParams("fl") == null) {
            throw new IOException("fl param expected for search function");
        }
    }

    public void setFieldMappings(Map<String, String> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new LinkedList();
        this.solrStreams = new ArrayList<TupleStream>();
        this.eofTuples = Collections.synchronizedMap(new HashMap());
        this.constructStreams();
        this.openStreams();
    }

    @Override
    public List<TupleStream> children() {
        return this.solrStreams;
    }

    protected void constructStreams() throws IOException {
        try {
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            mParams = this.adjustParams(mParams);
            mParams.set("distrib", "false");
            List<String> shardUrls = DeepRandomStream.getShards(this.zkHost, this.collection, this.streamContext, mParams);
            String rows = mParams.get("rows");
            int r = Integer.parseInt(rows);
            int newRows = r / shardUrls.size();
            mParams.set("rows", Integer.toString(newRows));
            int seed = new Random().nextInt();
            mParams.set("sort", "random_" + Integer.toString(seed) + " asc");
            int remainder = r - newRows * shardUrls.size();
            for (String shardUrl : shardUrls) {
                ModifiableSolrParams useParams = null;
                if (this.solrStreams.size() == 0 && remainder > 0) {
                    useParams = new ModifiableSolrParams(mParams);
                    useParams.set("rows", newRows + remainder);
                } else {
                    useParams = mParams;
                }
                SolrStream solrStream = new SolrStream(shardUrl, useParams);
                if (this.streamContext != null) {
                    solrStream.setStreamContext(this.streamContext);
                }
                solrStream.setFieldMappings(this.fieldMappings);
                this.solrStreams.add(solrStream);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStreams() throws IOException {
        ExecutorService service = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("DeepRandomStream"));
        try {
            ArrayList<Future<TupleWrapper>> futures = new ArrayList<Future<TupleWrapper>>();
            for (TupleStream tupleStream : this.solrStreams) {
                StreamOpener so = new StreamOpener((SolrStream)tupleStream, this.comp);
                Future<TupleWrapper> future = service.submit(so);
                futures.add(future);
            }
            try {
                for (Future future : futures) {
                    TupleWrapper w = (TupleWrapper)future.get();
                    if (w == null) continue;
                    this.tuples.add(w);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.solrStreams != null) {
            for (TupleStream solrStream : this.solrStreams) {
                solrStream.close();
            }
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comp;
    }

    @Override
    public Tuple read() throws IOException {
        return this._read();
    }

    protected Tuple _read() throws IOException {
        if (this.tuples.size() > 0) {
            TupleWrapper tw = this.tuples.removeFirst();
            Tuple t = tw.getTuple();
            if (this.trace) {
                t.put("_COLLECTION_", this.collection);
            }
            if (tw.next()) {
                this.tuples.addLast(tw);
            }
            return t;
        }
        Tuple tuple = Tuple.EOF();
        if (this.trace) {
            tuple.put("_COLLECTION_", this.collection);
        }
        return tuple;
    }

    protected ModifiableSolrParams adjustParams(ModifiableSolrParams params) {
        return params;
    }

    protected class StreamOpener
    implements Callable<TupleWrapper> {
        private SolrStream stream;
        private StreamComparator comp;

        public StreamOpener(SolrStream stream, StreamComparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public TupleWrapper call() throws Exception {
            this.stream.open();
            TupleWrapper wrapper = new TupleWrapper(this.stream, this.comp);
            if (wrapper.next()) {
                return wrapper;
            }
            return null;
        }
    }

    protected class TupleWrapper
    implements Comparable<TupleWrapper> {
        private Tuple tuple;
        private SolrStream stream;
        private StreamComparator comp;

        public TupleWrapper(SolrStream stream, StreamComparator comp) {
            this.stream = stream;
            this.comp = comp;
        }

        @Override
        public int compareTo(TupleWrapper w) {
            if (this == w) {
                return 0;
            }
            int i = this.comp.compare(this.tuple, w.tuple);
            if (i == 0) {
                return 1;
            }
            return i;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hash(this.tuple);
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public boolean next() throws IOException {
            this.tuple = this.stream.read();
            if (this.tuple.EOF) {
                DeepRandomStream.this.eofTuples.put(this.stream.getBaseUrl(), this.tuple);
            }
            return !this.tuple.EOF;
        }
    }
}

