/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataOutput;

public class ChannelImageOutputStream
extends ChannelDataOutput
implements DataOutput,
Closeable {
    public ChannelImageOutputStream(String string, WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        super(string, writableByteChannel, byteBuffer);
    }

    public ChannelImageOutputStream(ChannelDataOutput channelDataOutput) throws IOException {
        super(channelDataOutput.filename, channelDataOutput.channel, channelDataOutput.buffer);
    }

    @Override
    public final void write(int n) throws IOException {
        this.writeByte(n);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1 : 0);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.write(byArray);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        this.writeChars(string.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUTF(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        if (byArray.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(Resources.format((short)6, this.filename, (short)Short.MAX_VALUE, byArray.length));
        }
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            this.writeShort(byArray.length);
            this.write(byArray);
        }
        finally {
            this.buffer.order(byteOrder);
        }
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }
}

