/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;

abstract class MimeTypeDetector {
    private final Map<String, String> mimeForNameSpaces;
    private final Map<String, String> mimeForRootElements;
    private static final byte[] XMLNS = new byte[]{120, 109, 108, 110, 115};
    private static final int MAX_ASCII = 126;
    private byte[] buffer = new byte[32];
    private int length;
    boolean insufficientBytes;

    MimeTypeDetector(Map<String, String> map, Map<String, String> map2) {
        this.mimeForNameSpaces = map;
        this.mimeForRootElements = map2;
    }

    private String current() throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.length, "US-ASCII");
    }

    private void remember(int n) {
        if (this.length >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
        }
        this.buffer[this.length++] = (byte)n;
    }

    abstract int read() throws IOException;

    private int readAfter(int n) throws IOException {
        int n2;
        boolean bl = false;
        while ((n2 = this.read()) >= 0) {
            if (n2 == 34) {
                bl = !bl;
                continue;
            }
            if (n2 != n || bl) continue;
            return this.read();
        }
        return -1;
    }

    private int afterSpaces(int n) throws IOException {
        while (n <= 32 && n >= 0) {
            n = this.read();
        }
        return n;
    }

    private int matches(byte[] byArray, int n, int n2, char c) throws IOException {
        if (n2 >= 0) {
            for (int i = 0; i < n; ++i) {
                if (n2 != byArray[i]) {
                    return n2 >= 0 ? 0 : -1;
                }
                n2 = this.read();
            }
            if ((n2 = this.afterSpaces(n2)) >= 0) {
                return n2 == c ? 1 : 0;
            }
        }
        return -1;
    }

    final String getMimeType() throws IOException {
        int n;
        block16: {
            String string;
            if (this.readAfter(63) != 62) {
                return null;
            }
            while ((n = this.readAfter(60)) == 33) {
                do {
                    n = this.readAfter(45);
                    while (n == 45) {
                        n = this.read();
                    }
                    if (n >= 0) continue;
                    return null;
                } while (n != 62);
            }
            n = this.afterSpaces(n);
            while (n > 32 && n != 58) {
                if (n == 62 || n > 126) {
                    return null;
                }
                this.remember(n);
                n = this.read();
            }
            if ((n = this.afterSpaces(n)) != 58) {
                string = this.current();
                this.length = 0;
            } else {
                string = null;
                n = this.afterSpaces(this.read());
            }
            do {
                int n2;
                if ((n2 = this.matches(XMLNS, XMLNS.length, n, this.length == 0 ? (char)'=' : ':')) == 0) continue;
                if (n2 < 0) {
                    return null;
                }
                if (this.length != 0) {
                    n2 = this.matches(this.buffer, this.length, this.afterSpaces(this.read()), '=');
                    if (n2 == 0) continue;
                    if (n2 < 0) {
                        return null;
                    }
                }
                break block16;
            } while ((n = this.afterSpaces(this.read())) >= 0 && n != 62);
            if (n >= 0 && string != null) {
                return this.mimeForRootElements.get(string);
            }
            return null;
        }
        this.length = 0;
        n = this.afterSpaces(this.read());
        if (n != 34) {
            return null;
        }
        n = this.afterSpaces(this.read());
        do {
            if (n < 0 || n > 126) {
                return null;
            }
            this.remember(n);
        } while ((n = this.read()) != 34);
        return this.mimeForNameSpaces.get(this.current());
    }

    final ProbeResult probeContent() throws DataStoreException {
        String string;
        boolean bl = true;
        try {
            string = this.getMimeType();
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        if (string == null) {
            if (this.insufficientBytes) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            bl = false;
            string = "application/xml";
        }
        return new ProbeResult(bl, string, null);
    }
}

