/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.mcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifoldCFSearchComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "mcf";
    public static final String AUTHENTICATED_USER_NAME = "AuthenticatedUserName";
    public static final String AUTHENTICATED_USER_DOMAIN = "AuthenticatedUserDomain";
    public static final String AUTHENTICATED_USER_NAME_PREFIX = "AuthenticatedUserName_";
    public static final String AUTHENTICATED_USER_DOMAIN_PREFIX = "AuthenticatedUserDomain_";
    public static final String USER_TOKENS = "UserTokens";
    public static final String NOSECURITY_TOKEN = "__nosecurity__";
    private static final String[] globalAllowed = new String[]{"solrpingquery"};
    private static final Logger LOG = LoggerFactory.getLogger(ManifoldCFSearchComponent.class);
    String authorityBaseURL = null;
    String fieldAllowDocument = null;
    String fieldDenyDocument = null;
    String fieldAllowShare = null;
    String fieldDenyShare = null;
    String fieldAllowParent = null;
    String fieldDenyParent = null;
    int connectionTimeOut;
    int socketTimeOut;
    PoolingHttpClientConnectionManager httpConnectionManager = null;
    HttpClient client = null;
    int poolSize;

    public void init(NamedList args) {
        Integer cTimeOut;
        super.init(args);
        this.authorityBaseURL = (String)args.get("AuthorityServiceBaseURL");
        if (this.authorityBaseURL == null) {
            LOG.info("USING DEFAULT BASE URL!!");
            this.authorityBaseURL = "http://localhost:8345/mcf-authority-service";
        }
        this.connectionTimeOut = (cTimeOut = (Integer)args.get("ConnectionTimeOut")) == null ? 60000 : cTimeOut;
        Integer timeOut = (Integer)args.get("SocketTimeOut");
        this.socketTimeOut = timeOut == null ? 300000 : timeOut;
        String allowAttributePrefix = (String)args.get("AllowAttributePrefix");
        String denyAttributePrefix = (String)args.get("DenyAttributePrefix");
        if (allowAttributePrefix == null) {
            allowAttributePrefix = "allow_token_";
        }
        if (denyAttributePrefix == null) {
            denyAttributePrefix = "deny_token_";
        }
        this.fieldAllowDocument = allowAttributePrefix + "document";
        this.fieldDenyDocument = denyAttributePrefix + "document";
        this.fieldAllowShare = allowAttributePrefix + "share";
        this.fieldDenyShare = denyAttributePrefix + "share";
        this.fieldAllowParent = allowAttributePrefix + "parent";
        this.fieldDenyParent = denyAttributePrefix + "parent";
        Integer connectionPoolSize = (Integer)args.get("ConnectionPoolSize");
        this.poolSize = connectionPoolSize == null ? 50 : connectionPoolSize;
        this.httpConnectionManager = new PoolingHttpClientConnectionManager();
        this.httpConnectionManager.setMaxTotal(this.poolSize);
        this.httpConnectionManager.setDefaultMaxPerRoute(this.poolSize);
        this.httpConnectionManager.setValidateAfterInactivity(2000);
        this.httpConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeOut).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeOut).setExpectContinueEnabled(true).setConnectTimeout(this.connectionTimeOut).setConnectionRequestTimeout(this.socketTimeOut);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        this.client = clientBuilder.build();
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        List<Object> userAccessTokens;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, true) || params.get("shards") != null) {
            return;
        }
        String qry = params.get("q");
        if (qry != null) {
            for (String ga : globalAllowed) {
                if (!qry.equalsIgnoreCase(ga.trim())) continue;
                return;
            }
        }
        HashMap<String, String> domainMap = new HashMap<String, String>();
        String authenticatedUserName = params.get(AUTHENTICATED_USER_NAME);
        if (authenticatedUserName != null) {
            String authenticatedUserDomain = params.get(AUTHENTICATED_USER_DOMAIN);
            if (authenticatedUserDomain == null) {
                authenticatedUserDomain = "";
            }
            domainMap.put(authenticatedUserDomain, authenticatedUserName);
        } else {
            int i = 0;
            while (true) {
                String userName = params.get(AUTHENTICATED_USER_NAME_PREFIX + i);
                Object domain = params.get(AUTHENTICATED_USER_DOMAIN_PREFIX + i);
                if (userName == null) break;
                if (domain == null) {
                    domain = "";
                }
                domainMap.put((String)domain, userName);
                ++i;
            }
        }
        if (domainMap.size() == 0) {
            userAccessTokens = new ArrayList();
            String[] passedTokens = params.getParams(USER_TOKENS);
            if (passedTokens == null) {
                LOG.info("Default no-user response (open documents only)");
            } else {
                LOG.info("Group tokens received from caller");
                userAccessTokens.addAll(Arrays.asList(passedTokens));
            }
        } else {
            if (LOG.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder("[");
                boolean first = true;
                for (String domain : domainMap.keySet()) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(domain).append(":").append((String)domainMap.get(domain));
                }
                sb.append("]");
                LOG.info("Trying to match docs for user '" + sb.toString() + "'");
            }
            if (this.authorityBaseURL == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing ManifoldCFSecurityFilter component: 'AuthorityServiceBaseURL' init parameter required");
            }
            userAccessTokens = this.getAccessTokens(domainMap);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        TermQuery allowShareOpen = new TermQuery(new Term(this.fieldAllowShare, NOSECURITY_TOKEN));
        TermQuery denyShareOpen = new TermQuery(new Term(this.fieldDenyShare, NOSECURITY_TOKEN));
        TermQuery allowParentOpen = new TermQuery(new Term(this.fieldAllowParent, NOSECURITY_TOKEN));
        TermQuery denyParentOpen = new TermQuery(new Term(this.fieldDenyParent, NOSECURITY_TOKEN));
        TermQuery allowDocumentOpen = new TermQuery(new Term(this.fieldAllowDocument, NOSECURITY_TOKEN));
        TermQuery denyDocumentOpen = new TermQuery(new Term(this.fieldDenyDocument, NOSECURITY_TOKEN));
        if (userAccessTokens.size() == 0) {
            bq.add((Query)allowShareOpen, BooleanClause.Occur.MUST);
            bq.add((Query)denyShareOpen, BooleanClause.Occur.MUST);
            bq.add((Query)allowParentOpen, BooleanClause.Occur.MUST);
            bq.add((Query)denyParentOpen, BooleanClause.Occur.MUST);
            bq.add((Query)allowDocumentOpen, BooleanClause.Occur.MUST);
            bq.add((Query)denyDocumentOpen, BooleanClause.Occur.MUST);
        } else {
            bq.add(this.calculateCompleteSubquery(this.fieldAllowShare, this.fieldDenyShare, (Query)allowShareOpen, (Query)denyShareOpen, userAccessTokens), BooleanClause.Occur.MUST);
            bq.add(this.calculateCompleteSubquery(this.fieldAllowParent, this.fieldDenyParent, (Query)allowParentOpen, (Query)denyParentOpen, userAccessTokens), BooleanClause.Occur.MUST);
            bq.add(this.calculateCompleteSubquery(this.fieldAllowDocument, this.fieldDenyDocument, (Query)allowDocumentOpen, (Query)denyDocumentOpen, userAccessTokens), BooleanClause.Occur.MUST);
        }
        ArrayList<ConstantScoreQuery> list = rb.getFilters();
        if (list == null) {
            list = new ArrayList<ConstantScoreQuery>();
            rb.setFilters(list);
        }
        list.add(new ConstantScoreQuery((Query)bq.build()));
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    protected Query calculateCompleteSubquery(String allowField, String denyField, Query allowOpen, Query denyOpen, List<String> userAccessTokens) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        BooleanQuery.setMaxClauseCount((int)1000000);
        BooleanQuery.Builder subUnprotectedClause = new BooleanQuery.Builder();
        subUnprotectedClause.add(allowOpen, BooleanClause.Occur.MUST);
        subUnprotectedClause.add(denyOpen, BooleanClause.Occur.MUST);
        bq.add((Query)subUnprotectedClause.build(), BooleanClause.Occur.SHOULD);
        for (String accessToken : userAccessTokens) {
            bq.add((Query)new TermQuery(new Term(allowField, accessToken)), BooleanClause.Occur.SHOULD);
            bq.add((Query)new TermQuery(new Term(denyField, accessToken)), BooleanClause.Occur.MUST_NOT);
        }
        return bq.build();
    }

    public String getDescription() {
        return "ManifoldCF Solr security enforcement plugin";
    }

    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    public void inform(SolrCore core) {
        core.addCloseHook((CloseHook)new CloseHandler());
    }

    /*
     * Exception decompiling
     */
    protected List<String> getAccessTokens(Map<String, String> domainMap) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class CloseHandler
    implements CloseHook {
        public void preClose(SolrCore core) {
        }

        public void postClose(SolrCore core) {
            if (ManifoldCFSearchComponent.this.httpConnectionManager != null) {
                ManifoldCFSearchComponent.this.httpConnectionManager.shutdown();
                ManifoldCFSearchComponent.this.httpConnectionManager = null;
                ManifoldCFSearchComponent.this.client = null;
            }
        }
    }
}

