/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.flow.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.SimpleStepWithResultSpec;
import org.apache.uima.flow.Step;
import org.apache.uima.flow.impl.AnalysisSequenceCapabilityNode;
import org.apache.uima.flow.impl.CapabilityLanguageFlowController;

public class CapabilityLanguageFlowObject
extends CasFlow_ImplBase
implements Cloneable {
    private static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
    private TypeSystem mLastTypeSystem;
    private final CapabilityLanguageFlowController mParentController;
    private int mIndex = 0;
    private Map<String, List<AnalysisSequenceCapabilityNode>> mFlowTable;
    private static final char LANGUAGE_SEPARATOR = '-';
    static final long serialVersionUID = -5879514955935785660L;

    public CapabilityLanguageFlowObject(Map<String, List<AnalysisSequenceCapabilityNode>> aFlowTable, CapabilityLanguageFlowController aParentController) {
        this.mFlowTable = aFlowTable;
        this.mLastTypeSystem = null;
        this.mParentController = aParentController;
    }

    @Override
    public Step next() {
        CAS cas = this.getCas();
        assert (cas != null);
        if (this.mLastTypeSystem != cas.getTypeSystem()) {
            this.mLastTypeSystem = cas.getTypeSystem();
            this.recompileFlowTable();
        }
        String documentLanguage = Language.normalize(cas.getDocumentLanguage());
        AnalysisSequenceCapabilityNode node = null;
        List<AnalysisSequenceCapabilityNode> flow = this.mFlowTable.get(documentLanguage);
        if (flow == null) {
            int index = documentLanguage.indexOf(45);
            if (index >= 0) {
                flow = this.mFlowTable.get(documentLanguage.substring(0, index));
                if (flow == null) {
                    flow = this.mFlowTable.get(UNSPECIFIED_LANGUAGE);
                }
            } else {
                flow = this.mFlowTable.get(UNSPECIFIED_LANGUAGE);
            }
        }
        if (flow != null && flow.size() > this.mIndex) {
            node = flow.get(this.mIndex++);
            while (node == null && flow.size() > this.mIndex) {
                node = flow.get(this.mIndex++);
            }
        }
        if (node != null) {
            Map<String, ResultSpecification> lastResultSpecForComponent = this.mParentController.getLastResultSpecForComponent();
            String component = node.getCasProcessorKey();
            ResultSpecification neededResultSpec = node.getResultSpec();
            ResultSpecification previousResultSpec = lastResultSpecForComponent.get(component);
            if (null == previousResultSpec || previousResultSpec != neededResultSpec) {
                lastResultSpecForComponent.put(component, neededResultSpec);
                return new SimpleStepWithResultSpec(component, neededResultSpec);
            }
            return new SimpleStepWithResultSpec(node.getCasProcessorKey(), null);
        }
        return new FinalStep();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void resetIndex() {
        this.mIndex = 0;
    }

    protected void recompileFlowTable() {
        if (this.mFlowTable != null) {
            this.mParentController.getLastResultSpecForComponent().clear();
            Set<String> keys = this.mFlowTable.keySet();
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                List<AnalysisSequenceCapabilityNode> sequence = this.mFlowTable.get(it.next());
                for (int i = 0; i < sequence.size(); ++i) {
                    AnalysisSequenceCapabilityNode node = sequence.get(i);
                    if (node == null) continue;
                    node.getResultSpec().setTypeSystem(this.mLastTypeSystem);
                }
            }
        }
    }
}

