/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.SAMLConfig;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.URI;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0002
extends SAMLArtifact {
    public static final Artifact.TypeCode TYPE_CODE = new SAMLArtifact.TypeCode(0, 2);

    public SAMLArtifactType0002(URI uRI) {
        SAMLArtifactType0002.checkNullArg(uRI);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(uRI);
    }

    public SAMLArtifactType0002(byte[] byArray, URI uRI) {
        SAMLArtifactType0002.checkHandleArg(byArray);
        SAMLArtifactType0002.checkNullArg(uRI);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(byArray, uRI);
    }

    public SAMLArtifactType0002(Artifact.RemainingArtifact remainingArtifact) {
        SAMLArtifactType0002.checkNullArg(remainingArtifact);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = remainingArtifact;
    }

    public byte[] getAssertionHandle() {
        return ((RemainingArtifact)this.remainingArtifact).getAssertionHandle();
    }

    public URI getSourceLocation() {
        return ((RemainingArtifact)this.remainingArtifact).getSourceLocation();
    }

    public static final class Parser
    implements Artifact.Parser {
        public Artifact parse(String string) throws ArtifactParseException {
            URI uRI;
            int n;
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
            if (byArray.length < (n = 22)) {
                throw new ArtifactParseException(byArray.length, n);
            }
            SAMLArtifact.TypeCode typeCode = new SAMLArtifact.TypeCode(byArray[0], byArray[1]);
            if (!typeCode.equals(TYPE_CODE)) {
                throw new ArtifactParseException(typeCode, TYPE_CODE);
            }
            byte[] byArray2 = new byte[20];
            System.arraycopy(byArray, 2, byArray2, 0, 20);
            int n2 = byArray.length - n;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            try {
                uRI = new URI(byArray3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ArtifactParseException("UTF-8 unsupported string format, can not create artifact URI");
            }
            return new SAMLArtifactType0002(byArray2, uRI);
        }
    }

    public static final class RemainingArtifact
    extends SAMLArtifact.RemainingArtifact {
        private byte[] assertionHandle;
        private URI sourceLocation;
        private byte[] sourceLocationBytes;

        public RemainingArtifact(URI uRI) {
            byte[] byArray = SAMLConfig.instance().getDefaultIDProvider().generateRandomBytes(20);
            RemainingArtifact remainingArtifact = new RemainingArtifact(byArray, uRI);
            this.assertionHandle = remainingArtifact.assertionHandle;
            this.sourceLocation = remainingArtifact.sourceLocation;
            this.sourceLocationBytes = remainingArtifact.sourceLocationBytes;
        }

        public RemainingArtifact(byte[] byArray, URI uRI) {
            SAMLArtifact.checkHandleArg(byArray);
            SAMLArtifact.checkNullArg(uRI);
            this.assertionHandle = byArray;
            this.sourceLocation = uRI;
            this.sourceLocationBytes = uRI.toBytes();
        }

        public byte[] getAssertionHandle() {
            return this.assertionHandle;
        }

        public URI getSourceLocation() {
            return this.sourceLocation;
        }

        public int size() {
            return this.assertionHandle.length + this.sourceLocationBytes.length;
        }

        public byte[] getBytes() {
            byte[] byArray = this.assertionHandle;
            byte[] byArray2 = this.sourceLocationBytes;
            return Util.concat(byArray, byArray2);
        }

        public int hashCode() {
            return this.assertionHandle.hashCode() & this.sourceLocationBytes.hashCode();
        }
    }
}

