/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.rss;

import java.net.URI;
import java.net.URISyntaxException;

public class WebURL {
    protected URI theURL;
    protected String rawQueryPart;

    public WebURL(String url) throws URISyntaxException {
        this.theURL = new URI(url);
        this.rawQueryPart = null;
    }

    public WebURL(String scheme, String host, int port, String path, String queryPart) throws URISyntaxException {
        this.theURL = new URI(scheme, null, host, port, path, null, null);
        this.rawQueryPart = queryPart;
    }

    public WebURL(URI theURL) {
        this(theURL, null);
    }

    public WebURL(URI theURL, String rawQueryPart) {
        this.theURL = theURL;
        this.rawQueryPart = rawQueryPart;
    }

    public WebURL resolve(String raw) throws URISyntaxException {
        URI rawURL = new URI(raw);
        if (rawURL.isAbsolute()) {
            return new WebURL(rawURL);
        }
        URI fixedURL = this.theURL;
        if (this.theURL.getPath() == null || this.theURL.getPath().length() == 0) {
            fixedURL = new URI(this.theURL.getScheme(), null, this.theURL.getHost(), this.theURL.getPort(), "/", null, null);
        }
        if (raw.startsWith("?")) {
            return new WebURL(fixedURL.getScheme(), fixedURL.getHost(), fixedURL.getPort(), fixedURL.getPath(), rawURL.getRawQuery());
        }
        return new WebURL(fixedURL.resolve(rawURL));
    }

    public String getPath() {
        return this.theURL.getPath();
    }

    public String getHost() {
        return this.theURL.getHost();
    }

    public String getScheme() {
        return this.theURL.getScheme();
    }

    public int getPort() {
        return this.theURL.getPort();
    }

    public String getRawQuery() {
        if (this.rawQueryPart != null) {
            return this.rawQueryPart;
        }
        return this.theURL.getRawQuery();
    }

    public String toASCIIString() {
        Object rval = this.theURL.toASCIIString();
        if (rval != null && this.rawQueryPart != null && this.rawQueryPart.length() > 0) {
            rval = (String)rval + "?" + this.rawQueryPart;
        }
        return rval;
    }

    public String toString() {
        Object rval = this.theURL.toString();
        if (rval != null && this.rawQueryPart != null && this.rawQueryPart.length() > 0) {
            rval = (String)rval + "?" + this.rawQueryPart;
        }
        return rval;
    }
}

