/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.manifoldcf.connectorcommon.fuzzyml.ByteBuffer;

public class PrefixedInputStream
extends InputStream {
    protected final ByteBuffer bytes;
    protected final InputStream remainderStream;
    protected int bytePosition = 0;
    protected int byteMax;

    public PrefixedInputStream(ByteBuffer bytes, InputStream remainderStream) {
        this.bytes = bytes;
        this.remainderStream = remainderStream;
        this.byteMax = bytes.size();
    }

    @Override
    public int read() throws IOException {
        if (this.bytePosition < this.byteMax) {
            return 0xFF & this.bytes.readByte(this.bytePosition++);
        }
        return this.remainderStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytePosition < this.byteMax) {
            return super.read(b, off, len);
        }
        return this.remainderStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bytePosition < this.byteMax) {
            return super.skip(n);
        }
        return this.remainderStream.skip(n);
    }

    @Override
    public void close() throws IOException {
    }
}

