/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;

public class AuthRequest {
    public static final String _rcsid = "@(#)$Id: AuthRequest.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String userID;
    protected final IAuthorityConnection authorityConnection;
    protected final String identifyingString;
    protected boolean answerComplete = false;
    protected AuthorizationResponse answerResponse = null;
    protected Throwable answerException = null;

    public AuthRequest(IAuthorityConnection authorityConnection, String identifyingString) {
        this.authorityConnection = authorityConnection;
        this.identifyingString = identifyingString;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserID() {
        return this.userID;
    }

    public IAuthorityConnection getAuthorityConnection() {
        return this.authorityConnection;
    }

    public String getIdentifyingString() {
        return this.identifyingString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete() throws InterruptedException {
        AuthRequest authRequest = this;
        synchronized (authRequest) {
            if (this.answerComplete) {
                return;
            }
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRequest(AuthorizationResponse answerResponse, Throwable answerException) {
        AuthRequest authRequest = this;
        synchronized (authRequest) {
            if (this.answerComplete) {
                return;
            }
            this.answerComplete = true;
            this.answerResponse = answerResponse;
            this.answerException = answerException;
            this.notifyAll();
        }
    }

    public AuthorizationResponse getAnswerResponse() {
        return this.answerResponse;
    }

    public Throwable getAnswerException() {
        return this.answerException;
    }
}

