/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.system.Logging;

public class PriorityCalculator
implements IPriorityCalculator {
    public static final String _rcsid = "@(#)$Id$";
    private static final double minMsPerFetch = 50.0;
    protected final IRepositoryConnection connection;
    protected final String[] binNames;
    protected final String documentIdentifier;
    protected final IReprioritizationTracker rt;
    protected final double[] binCountScaleFactors;
    protected final double[] weightedMinimumDepths;
    protected Double cachedValue = null;

    public PriorityCalculator(IReprioritizationTracker rt, IRepositoryConnection connection, String[] documentBins, String documentIdentifier) throws ManifoldCFException {
        this(rt, rt.getMinimumDepth(), connection, documentBins, documentIdentifier);
    }

    public PriorityCalculator(IReprioritizationTracker rt, double currentMinimumDepth, IRepositoryConnection connection, String[] documentBins, String documentIdentifier) throws ManifoldCFException {
        this.documentIdentifier = documentIdentifier;
        this.connection = connection;
        this.binNames = documentBins;
        this.rt = rt;
        this.binCountScaleFactors = new double[this.binNames.length];
        this.weightedMinimumDepths = new double[this.binNames.length];
        double[] maxFetchRates = PriorityCalculator.calculateMaxFetchRates(this.binNames, connection);
        for (int i = 0; i < this.binNames.length; ++i) {
            String binName = this.binNames[i];
            double maxFetchRate = maxFetchRates[i];
            double binCountScaleFactor = maxFetchRate == 0.0 ? Double.POSITIVE_INFINITY : 1.0 + 1.0 / (50.0 * maxFetchRate);
            this.binCountScaleFactors[i] = binCountScaleFactor;
            this.weightedMinimumDepths[i] = currentMinimumDepth / binCountScaleFactor;
        }
    }

    public void makePreloadRequest() {
        for (int i = 0; i < this.binNames.length; ++i) {
            String binName = this.binNames[i] == null ? "" : this.binNames[i];
            this.rt.addPreloadRequest(this.connection.getClassName(), binName, this.weightedMinimumDepths[i]);
        }
    }

    @Override
    public double getDocumentPriority() throws ManifoldCFException {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        double highestAdjustedCount = 0.0;
        for (int i = 0; i < this.binNames.length; ++i) {
            String binName = this.binNames[i];
            double binCountScaleFactor = this.binCountScaleFactors[i];
            double weightedMinimumDepth = this.weightedMinimumDepths[i];
            double thisCount = this.rt.getIncrementBinValue(this.connection.getClassName(), binName, weightedMinimumDepth);
            double adjustedCount = binCountScaleFactor == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : thisCount * binCountScaleFactor;
            if (!(adjustedCount > highestAdjustedCount)) continue;
            highestAdjustedCount = adjustedCount;
        }
        double returnValue = highestAdjustedCount == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.log(1.0 + highestAdjustedCount);
        if (Logging.scheduling.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            int k = 0;
            while (k < this.binNames.length) {
                sb.append(this.binNames[k++]).append(" ");
            }
            Logging.scheduling.debug((Object)("Document '" + this.documentIdentifier + "' with bins [" + sb.toString() + "] given priority value " + new Double(returnValue).toString()));
        }
        this.cachedValue = new Double(returnValue);
        return returnValue;
    }

    protected static double[] calculateMaxFetchRates(String[] binNames, IRepositoryConnection connection) {
        ThrottleLimits tl = new ThrottleLimits(connection);
        return tl.getMaximumRates(binNames);
    }

    protected static class ThrottleLimitSpec {
        protected final Pattern regexp;
        protected final double maxRate;

        public ThrottleLimitSpec(String regexp, double maxRate) throws PatternSyntaxException {
            this.regexp = Pattern.compile(regexp);
            this.maxRate = maxRate;
        }

        public Pattern getRegexp() {
            return this.regexp;
        }

        public double getMaxRate() {
            return this.maxRate;
        }
    }

    protected static class ThrottleLimits {
        protected List<ThrottleLimitSpec> specs = new ArrayList<ThrottleLimitSpec>();

        public ThrottleLimits(IRepositoryConnection connection) {
            String[] throttles = connection.getThrottles();
            for (int i = 0; i < throttles.length; ++i) {
                try {
                    this.specs.add(new ThrottleLimitSpec(throttles[i], connection.getThrottleValue(throttles[i])));
                    continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }

        public double[] getMaximumRates(String[] binNames) {
            double[] rval = new double[binNames.length];
            for (int j = 0; j < binNames.length; ++j) {
                String binName = binNames[j];
                double maxRate = Double.POSITIVE_INFINITY;
                for (ThrottleLimitSpec spec : this.specs) {
                    double rate;
                    Pattern p = spec.getRegexp();
                    Matcher m = p.matcher(binName);
                    if (!m.find() || !((rate = spec.getMaxRate()) < maxRate)) continue;
                    maxRate = rate;
                }
                rval[j] = maxRate;
            }
            return rval;
        }
    }
}

